//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TSettingsDialog.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TSettingsDialog *SettingsDialog	= NULL;

//---------------------------------------------------------------------------
__fastcall TSettingsDialog::TSettingsDialog(TComponent* Owner) : TForm(Owner) {
	itsUpdateFlag = 0;
	Setting = NULL;
}

//---------------------------------------------------------------------------
void __fastcall	TSettingsDialog::Populate( void ) {
	itsUpdateFlag++;
	NameEdit->Text = Setting->SettingName();
    FileEdit->Text = Setting->IniFileName();
    SectionEdit->Text = Setting->IniSectName();
    ItemEdit->Text = Setting->IniItemName();
	ValueEdit->Text = Setting->SettingValu();
    NoReplacingCheckBox->Checked = Setting->NoReplacing();
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TSettingsDialog::NameEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	Setting->SettingName( NameEdit->Text.c_str() );
}

//---------------------------------------------------------------------------
void __fastcall TSettingsDialog::FileEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	Setting->IniFileName( FileEdit->Text.c_str() );
}

//---------------------------------------------------------------------------
void __fastcall TSettingsDialog::SectionEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	Setting->IniSectName( SectionEdit->Text.c_str() );
}

//---------------------------------------------------------------------------
void __fastcall TSettingsDialog::ItemEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	Setting->IniItemName( ItemEdit->Text.c_str() );
}

//---------------------------------------------------------------------------
void __fastcall TSettingsDialog::ValueEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	Setting->SettingValu( ValueEdit->Text.c_str() );
}

//---------------------------------------------------------------------------
void __fastcall TSettingsDialog::NoReplacingCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	Setting->NoReplacing( NoReplacingCheckBox->Checked );
}

//---------------------------------------------------------------------------
void __fastcall TSettingsDialog::OkButtonClick(TObject *Sender) {
	ModalResult = mrOk;
}

//---------------------------------------------------------------------------
void __fastcall TSettingsDialog::CancelButtonClick(TObject *Sender) {
	ModalResult = mrCancel;
}

//---------------------------------------------------------------------------

