//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TUserEditDialog.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TUserEditDialog *UserEditDialog = NULL;

//---------------------------------------------------------------------------
// local:	Valid characters on user name and password
//---------------------------------------------------------------------------
static char *	__validChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJMLMNOPQRSTUVWXYZ0123456789!%^*(){}[]<>.,";

//---------------------------------------------------------------------------
__fastcall TUserEditDialog::TUserEditDialog(TComponent* Owner) : TForm(Owner) {
	itsUpdateFlag 	= 0;
    ServerData		= NULL;
    UserData		= NULL;
}

//---------------------------------------------------------------------------
// Verify given string to contain only valid characters
//---------------------------------------------------------------------------
bool __fastcall TUserEditDialog::VerifyName( const char * aName ) {
	bool	result = true;
	while ( *aName ) {
    	if	( ! ::strchr( __validChars, *aName ) ) {
	    	Application->MessageBox(	"Invalid character here",
    	    				   			"Invalid input",
        	                            MB_OK | MB_ICONWARNING );
            result = false;
            break;
        }
        aName++;
    }
	return result;
}

//---------------------------------------------------------------------------
void __fastcall TUserEditDialog::Populate( void ) {
	CFurserSrGrup_lci	loop;
	int					ix;

	itsUpdateFlag++;
	UserNameEdit->Text = UserData->UserName();
    PasswordEdit->Text = UserData->UserPass();
    CommentEdit->Text = UserData->Comment();
    EnabledCheckBox->Checked = UserData->Enabled();
	GroupsCheckListBox->Items->Clear();
	ix = 0;
    for	(	loop  = ServerData->GroupList().begin();
			loop != ServerData->GroupList().end();
            loop++, ix++ ) {
		GroupsCheckListBox->Items->Add( (*loop).GroupName() );
		GroupsCheckListBox->Checked[ix] = UserData->HasGroup( (*loop).GroupName() );
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TUserEditDialog::UserNameEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( TUserEditDialog::VerifyName( UserNameEdit->Text.c_str() ) ) {
	    UserData->UserName( UserNameEdit->Text.c_str() );
    }
    else {
		UserNameEdit->Text = UserData->UserName();
    }
}

//---------------------------------------------------------------------------
void __fastcall TUserEditDialog::PasswordEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    if	( TUserEditDialog::VerifyName( PasswordEdit->Text.c_str() ) ) {
	    UserData->UserPass( PasswordEdit->Text.c_str() );
    }
    else {
		PasswordEdit->Text = UserData->UserPass();
    }
}

//---------------------------------------------------------------------------
void __fastcall TUserEditDialog::CommentEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    UserData->Comment( CommentEdit->Text.c_str() );
}

//---------------------------------------------------------------------------
void __fastcall TUserEditDialog::EnabledCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
    UserData->Enabled( EnabledCheckBox->Checked );
}

//---------------------------------------------------------------------------
void __fastcall TUserEditDialog::OkButtonClick(TObject *Sender) {
	int					ix;

	// First, remove all groups from the user
    UserData->ClearGroups();

    // Loop through our group list and add all checked groups
    for	( ix = 0; ix < GroupsCheckListBox->Items->Count; ix++ ) {
    	if	( GroupsCheckListBox->Checked[ix] ) {
        	CFurserSrGrup	grup = ServerData->GetGroup( GroupsCheckListBox->Items->Strings[ix].c_str() );
            UserData->AddGroup( grup );
        }
    }

	ModalResult = mrOk;
}

//---------------------------------------------------------------------------
void __fastcall TUserEditDialog::CancelButtonClick(TObject *Sender) {
	ModalResult = mrCancel;
}

//---------------------------------------------------------------------------
