// --------------------------------------------------------------------
// CFurserClient.h
// Whatis:  Furser Client class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserClient_h
#define CFurserClient_h

#include	"CTcpSocket.hxx"

// --------------------------------------------------------------------
class CFurserClient {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserClient		( CTcpSocket *, const char * );	// Server side
	CFurserClient		( const char *, unsigned short, const char * );
	~CFurserClient		();

	// ----------------------------------------------------------------
	private:	// Copy constructor and assignment operator - unused
	// ----------------------------------------------------------------
	CFurserClient				( const CFurserClient & );
	CFurserClient & operator =	( const CFurserClient & );

	// ----------------------------------------------------------------
	public:		// Sending / receiving
	// ----------------------------------------------------------------
	void			TxResponse	( const char * );
    void			RxResponse	( const char * );
	void			TxData		( const char *, dword_t );	// Transmit
	void			TxDataDword	( dword_t );
	void			TxDataBool	( bool );
	void			TxDataInt	( int );
	void			TxDataTime	( time_t );

	char *			RxData		( void );					// Receive
    dword_t			RxDataDword	( void );
    bool			RxDataBool	( void );
    int				RxDataInt	( void );
    time_t			RxDataTime	( void );


   	byte_t			ReadCommand	( void );
   	byte_t			ReadCommand	( bool & );
    void			SendCommand	( byte_t );

    const char *	Address		( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			SendPasswd	( const char * );
	void			ReadPasswd	( const char * );
	byte_t			ReadByte	( void );
	void			Free		( void );
	void			Cleanup		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char			itsAddress	[512];
	CTcpSocket *	itsSocket;
};

#endif
// --------------------------------------------------------------------
// EOF:	CFurserClient.h
// --------------------------------------------------------------------
