// --------------------------------------------------------------------
// CFurserSrData.h
// Whatis:  Furser Server Data class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserSrData_h
#define CFurserSrData_h

#include	"CFurserClient.h"
#include	"CFurserSrSrvr.h"
#include	"CFurserString.h"
#include	"CWinIniFile.hxx"
#include	"CCpuMutex.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
class CFurserSrData {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserSrData		();
	~CFurserSrData		();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CFurserSrData				( const CFurserSrData & );
	CFurserSrData & operator =	( const CFurserSrData & );

	// ----------------------------------------------------------------
	public:		// Net operations (client or server)
	// ----------------------------------------------------------------
    void					NetSave		( CFurserClient &, bool = true );
    void					NetLoad		( CFurserClient &, bool = true );
    void					NetStart	( CFurserClient &, const char *, bool = true );
    void					NetStop		( CFurserClient &, const char *, bool = true );
    void					NetImmStart	( CFurserClient &, const char *, bool = true );
    void					NetImmStop	( CFurserClient &, const char *, bool = true );
    char *					NetLogdata	( CFurserClient &, const char *, bool = true );

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void					Load		( CFurserClient & );
	void					Load		( const char * );
	void					Load		( const CWinIniFile & );
	void					Save		( CFurserClient & );
	void					Save		( const char * );
    CError					Error		( void ) const;
    void					Error		( const CError & );
    void					Abort		( void );
    void					ForceProgress ( void );

	// ----------------------------------------------------------------
	public:		// List manipulation
	// ----------------------------------------------------------------
	bool					HasServer	( const char * ) const;
	CFurserSrSrvr			GetServer	( const char * ) const;
	void					SetServer	( const char *, const CFurserSrSrvr & );
	void					AddServer	( const CFurserSrSrvr & );
	void					DelServer	( const CFurserSrSrvr & );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const CFurserSrSrvr_l &	ServerList	( void ) const;
	CFurserSrSrvr_l &		ServerMList	( void );
    CFurserString_l			ServerNames	( void ) const;
    dword_t					ProgressEnd	( void );
    dword_t					ProgressPos	( void );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void			ProgressCalc( CFurserClient &, bool aIsLoading );
	void			Free		( void );
	void			Cleanup		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CFurserSrSrvr_l	itsServerList;
    dword_t			itsProgressEnd;
    dword_t			itsProgressPos;
    CError			itsError;
    CCpuMutex		itsMutex;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CFurserSrData>		CFurserSrData_l;
typedef CFurserSrData_l::iterator       CFurserSrData_li;
typedef CFurserSrData_l::const_iterator	CFurserSrData_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CFurserSrData.h
// --------------------------------------------------------------------
