// --------------------------------------------------------------------
// CFurserSrGame.h
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserSrGame_h
#define CFurserSrGame_h

#include	"CFurserClient.h"
#include	"CFurserSrSetn.h"
#include	"CWinIniFile.hxx"

// --------------------------------------------------------------------
class CFurserSrGame {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserSrGame		();
	~CFurserSrGame		();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CFurserSrGame				( const CFurserSrGame & );
	CFurserSrGame & operator =	( const CFurserSrGame & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator == ( const CFurserSrGame & ) const;
	bool operator != ( const CFurserSrGame & ) const;
	bool operator == ( const char * ) const;
	bool operator != ( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void			Load		( CFurserClient & );
	void			Load		( const CWinIniFile &, const char * );
	void			Save		( CFurserClient & );
	void			Save		( CWinIniFile &, const char * );

	// ----------------------------------------------------------------
	public:		// List manipulation
	// ----------------------------------------------------------------
	bool			HasSetting	( const char * ) const;
	CFurserSrSetn	GetSetting	( const char * ) const;
	void			SetSetting	( const char *, const CFurserSrSetn & );
	void			AddSetting	( const CFurserSrSetn & );
	void			DelSetting	( const CFurserSrSetn & );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
    const char *			MapPrefix	( void ) const;
    const char *			MapList		( void ) const;
	const char *			GameName	( void ) const;
	const char *			Description	( void ) const;
	const CFurserSrSetn_l &	SettingList	( void ) const;

	// ----------------------------------------------------------------
	void			MapPrefix	( const char * );
	void			MapList		( const char * );
	void			GameName	( const char * );
    void			Description	( const char * );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			Free		( void );
	void			Cleanup		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
    char *			itsMapPrefix;
    char *			itsMapList;
	char *			itsGameName;
    char *			itsDescription;
	CFurserSrSetn_l	itsSettingList;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CFurserSrGame>		CFurserSrGame_l;
typedef CFurserSrGame_l::iterator       CFurserSrGame_li;
typedef CFurserSrGame_l::const_iterator	CFurserSrGame_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CFurserSrGame.h
// --------------------------------------------------------------------
