// --------------------------------------------------------------------
// CFurserSrGrup.h
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserSrGrup_h
#define CFurserSrGrup_h

#include	"CFurserClient.h"
#include	"CWinIniFile.hxx"

// --------------------------------------------------------------------
class CFurserSrGrup {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserSrGrup		();
	~CFurserSrGrup		();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CFurserSrGrup				( const CFurserSrGrup & );
	CFurserSrGrup & operator =	( const CFurserSrGrup & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator == ( const CFurserSrGrup & ) const;
	bool operator != ( const CFurserSrGrup & ) const;
	bool operator == ( const char * ) const;
	bool operator != ( const char * ) const;

	// ----------------------------------------------------------------
	public:		// String that will be put into AdminGroups= entry
	// ----------------------------------------------------------------
    char *			IniString		( char *, size_t ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void			Load		( CFurserClient & );
	void			Load		( const CWinIniFile &, const char * );
	void			Save		( CFurserClient & );
	void			Save		( CWinIniFile &, const char * );

	// ----------------------------------------------------------------
	public:		// Privilege manipulation
	// ----------------------------------------------------------------
	bool			HasPrivilege	( const char * ) const;
    void			AddPrivilege	( const char * );
    void			DelPrivilege	( const char * );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *	GroupName	( void ) const;
	const char *	Privileges	( void ) const;
	int				GameSecLevel( void ) const;
    const char *	Comment		( void ) const;

	// ----------------------------------------------------------------
	void			GroupName	( const char * );
	void			Privileges	( const char * );
	void			GameSecLevel( int );
    void			Comment		( const char * );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			Free		( void );
	void			Cleanup		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *		itsGroupName;
	char *		itsPrivileges;
	int			itsGameSecLevel;
    char *		itsComment;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CFurserSrGrup>		CFurserSrGrup_l;
typedef CFurserSrGrup_l::iterator       CFurserSrGrup_li;
typedef CFurserSrGrup_l::const_iterator	CFurserSrGrup_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CFurserSrGrup.h
// --------------------------------------------------------------------
