// --------------------------------------------------------------------
// CFurserSrLevl.h
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserSrLevl_h
#define CFurserSrLevl_h

#include	"CFurserClient.h"
#include	"CWinIniFile.hxx"

// --------------------------------------------------------------------
class CFurserSrLevl {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserSrLevl		();
	~CFurserSrLevl		();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CFurserSrLevl				( const CFurserSrLevl & );
	CFurserSrLevl & operator =	( const CFurserSrLevl & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator == ( const CFurserSrLevl & ) const;
	bool operator != ( const CFurserSrLevl & ) const;
	bool operator == ( const char * ) const;
	bool operator != ( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void			Load		( CFurserClient & );
	void			Load		( const CWinIniFile &, const char * );
	void			Save		( CFurserClient & );
	void			Save		( CWinIniFile &, const char * );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *			MapName		( void ) const;
	const char *			GameClass	( void ) const;
	bool					Rotate		( void ) const;
	int						Order		( void ) const;

	// ----------------------------------------------------------------
	void			MapName		( const char * );
	void			GameClass	( const char * );
	void			Rotate		( bool );
	void			Order		( int );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			Free		( void );
	void			Cleanup		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *			itsMapName;
	char *			itsGameClass;
	bool			itsRotate;
	int				itsOrder;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CFurserSrLevl>			CFurserSrLevl_l;
typedef CFurserSrLevl_l::iterator       	CFurserSrLevl_li;
typedef CFurserSrLevl_l::const_iterator		CFurserSrLevl_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CFurserSrLevl.h
// --------------------------------------------------------------------
