// --------------------------------------------------------------------
// CFurserSrSetn.h
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserSrSetn_h
#define CFurserSrSetn_h

#include	"CFurserClient.h"
#include	"CWinIniFile.hxx"

// --------------------------------------------------------------------
class CFurserSrSetn {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserSrSetn	();
	~CFurserSrSetn	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CFurserSrSetn				( const CFurserSrSetn & );
	CFurserSrSetn & operator =	( const CFurserSrSetn & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator == ( const CFurserSrSetn & ) const;
	bool operator != ( const CFurserSrSetn & ) const;
	bool operator == ( const char * ) const;
	bool operator != ( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void			Load		( CFurserClient & );
	void			Load		( const CWinIniFile &, const char * );
	void			Save		( CFurserClient & );
	void			Save		( CWinIniFile &, const char * );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *	SettingName	( void ) const;
	const char *	SettingValu	( void ) const;
	const char *	IniFileName	( void ) const;
	const char *	IniSectName	( void ) const;
	const char *	IniItemName	( void ) const;
    bool			NoReplacing	( void ) const;

	// ----------------------------------------------------------------
	void			SettingName	( const char * );
	void			SettingValu	( const char * );
	void			IniFileName	( const char * );
	void			IniSectName	( const char * );
	void			IniItemName	( const char * );
    void			NoReplacing	( bool );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			Free		( void );
	void			Cleanup		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *			itsSettingName;
	char *			itsSettingValu;
	char *			itsIniFileName;
	char *			itsIniSectName;
	char *			itsIniItemName;
    bool			itsNoReplacing;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CFurserSrSetn>		CFurserSrSetn_l;
typedef CFurserSrSetn_l::iterator       CFurserSrSetn_li;
typedef CFurserSrSetn_l::const_iterator	CFurserSrSetn_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CFurserSrSetn.h
// --------------------------------------------------------------------
