// --------------------------------------------------------------------
// CFurserSrSrvr.h
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserSrSrvr_h
#define CFurserSrSrvr_h

#include	"CWinIniFile.hxx"
#include	"CFurserClient.h"
#include	"CFurserSrSetn.h"
#include	"CFurserSrEvnt.h"
#include	"CFurserSrGrup.h"
#include	"CFurserSrUser.h"
#include	"CFurserSrUban.h"
#include	"CFurserSrMuta.h"
#include	"CFurserSrGame.h"
#include	"CFurserSrLevl.h"
#include	"CFurserSrMacr.h"
#include	"CFurserWizQery.h"
#include	"CFurserString.h"

// --------------------------------------------------------------------
class CFurserSrSrvr {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserSrSrvr		();
	~CFurserSrSrvr		();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CFurserSrSrvr				( const CFurserSrSrvr & );
	CFurserSrSrvr & operator =	( const CFurserSrSrvr & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator == ( const CFurserSrSrvr & ) const;
	bool operator != ( const CFurserSrSrvr & ) const;
	bool operator == ( const char * ) const;
	bool operator != ( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void					Load		( CFurserClient &, dword_t & );
	void					Load		( const CWinIniFile &, const char * );
	void					Save		( CFurserClient &, dword_t & );
	void					Save		( CWinIniFile &, const char * );
    dword_t					ProgressCalc( void );

	// ----------------------------------------------------------------
	public:		// Map rotation
	// ----------------------------------------------------------------
    bool					FirstMap	( const CFurserSrLevl & ) const;
    bool					LastMap		( const CFurserSrLevl & ) const;
    void					Earlier		( const CFurserSrLevl &, bool );
    void					Later		( const CFurserSrLevl &, bool );
    void					Renumber	( void );
    int						RotateCount	( void ) const;

	// ----------------------------------------------------------------
	public:		// Mutator load flag manipulation
	// ----------------------------------------------------------------
    void					ScanLoadFlags	( void );
    void					SetLoadFlag		( const char *, bool );

	// ----------------------------------------------------------------
	public:		// Macro expansion
	// ----------------------------------------------------------------
	void					ExpandMacros	( char *, size_t ) const;

	// ----------------------------------------------------------------
	public:		// Rewrites defined config files
	// ----------------------------------------------------------------
	void					GameConfigFiles	( const char *, char ) const;

	// ----------------------------------------------------------------
	public:		// List manipulation
	// ----------------------------------------------------------------
	bool					HasSetting	( const char * ) const;
	CFurserSrSetn			GetSetting	( const char * ) const;
	void					SetSetting	( const char *, const CFurserSrSetn & );
	void					AddSetting	( const CFurserSrSetn & );
	void					DelSetting	( const CFurserSrSetn & );

	bool					HasEvent	( const char * ) const;
	CFurserSrEvnt			GetEvent	( const char * ) const;
	void					SetEvent	( const char *, const CFurserSrEvnt & );
	void					AddEvent	( const CFurserSrEvnt & );
	void					DelEvent	( const CFurserSrEvnt & );

	bool					HasGroup	( const char * ) const;
	CFurserSrGrup			GetGroup	( const char * ) const;
	void					SetGroup	( const char *, const CFurserSrGrup & );
	void					AddGroup	( const CFurserSrGrup & );
	void					DelGroup	( const CFurserSrGrup & );

	bool					HasUser		( const char * ) const;
	CFurserSrUser			GetUser		( const char * ) const;
	void					SetUser		( const char *, const CFurserSrUser & );
	void					AddUser		( const CFurserSrUser & );
	void					DelUser		( const CFurserSrUser & );

	bool					HasBan		( const char * ) const;
	CFurserSrUban			GetBan		( const char * ) const;
	void					SetBan		( const char *, const CFurserSrUban & );
	void					AddBan		( const CFurserSrUban & );
	void					DelBan		( const CFurserSrUban & );

	bool					HasMutator	( const char * ) const;
	CFurserSrMuta			GetMutator	( const char * ) const;
	void					SetMutator	( const char *, const CFurserSrMuta & );
	void					AddMutator	( const CFurserSrMuta & );
	void					DelMutator	( const CFurserSrMuta & );

	bool					HasGame		( const char * ) const;
	CFurserSrGame			GetGame		( const char * ) const;
	void					SetGame		( const char *, const CFurserSrGame & );
	void					AddGame		( const CFurserSrGame & );
	void					DelGame		( const CFurserSrGame & );

	bool					HasMap		( const char * ) const;
	CFurserSrLevl			GetMap		( const char * ) const;
	void					SetMap		( const char *, const CFurserSrLevl & );
	void					AddMap		( const CFurserSrLevl & );
	void					DelMap		( const CFurserSrLevl & );

	bool					HasMacro	( const char * ) const;
	CFurserSrMacr			GetMacro	( const char * ) const;
	void					SetMacro	( const char *, const CFurserSrMacr & );
	void					AddMacro	( const CFurserSrMacr & );
	void					DelMacro	( const CFurserSrMacr & );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	bool					Running			( void ) const;
	bool					GameRunning		( void ) const;
	int						ServerType		( void ) const;
	const char *			ServerName		( void ) const;
	const char *			GameRoot		( void ) const;
	const char *			ExtraUccFlags	( void ) const;
	bool					UsesAdminName	( void ) const;
	const char *			AdminName		( void ) const;
	const char *			AdminPass		( void ) const;
	bool					UsesGamePass	( void ) const;
	const char *			GamePass		( void ) const;
	bool					UsesWebAdmin	( void ) const;
	unsigned short			WebAdminPort	( void ) const;
	const CFurserSrSetn_l &	SettingList		( void ) const;
	void					SettingList		( const CFurserSrSetn_l & );
	const CFurserSrEvnt_l &	EventList		( void ) const;
	const CFurserSrGrup_l &	GroupList		( void ) const;
	const CFurserSrUser_l &	UserList		( void ) const;
	const CFurserSrUban_l &	BanList			( void ) const;
	const CFurserSrMuta_l &	MutatorList		( void ) const;
	const CFurserSrGame_l &	GameList		( void ) const;
	const CFurserSrLevl_l &	MapList			( void ) const;
	const CFurserSrMacr_l &	MacroList		( void ) const;
	void					MacroList		( const CFurserWizQery_l & );

	// ----------------------------------------------------------------
	void					Running			( bool );
	void					GameRunning		( bool );
	void					ServerType		( int );
	void					ServerName		( const char * );
	void					GameRoot		( const char * );
	void					ExtraUccFlags	( const char * );
	void					UsesAdminName	( bool );
	void					AdminName		( const char * );
	void					AdminPass		( const char * );
	void					UsesGamePass	( bool );
	void					GamePass		( const char * );
	void					UsesWebAdmin	( bool );
	void					WebAdminPort	( unsigned short );


	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			Free				( void );
	void			Cleanup				( void );
    void			ReplaceMacro		( const char *, const char * );
    void			ReplaceMacro		( const char *, int );
    void			ReplaceMacro		( const char *, bool );

	// ----------------------------------------------------------------
	private:	// Private helpers for game ini file creation
	// ----------------------------------------------------------------
    CFurserString_l	ListConfigFiles		( void ) const;
    void			MutaConfigFiles		( CFurserString_l & ) const;
    void			GameConfigFiles		( CFurserString_l & ) const;
    void			SetnConfigFiles		( const CFurserSrSetn_l &, CFurserString_l & ) const;
	void			ListConfigFile		( CFurserString_l &, const char * ) const;
	void			CreateMainIniFile	( const char *, char, const char * ) const;
	void			CreateOthrIniFile	( const char *, char, const char * ) const;
	void			CreateAuthIniFile	( const char *, char ) const;
	void			CreateSetnIniFile	( CWinIniFile &, const CFurserSrSetn_l &, const char * ) const;
	void			CreateMutaIniFile	( CWinIniFile &, const char * ) const;
	void			CreateGameIniFile	( CWinIniFile &, const char * ) const;
	void			CreateMapRota1999	( CWinIniFile & ) const;
	void			CreateMapRota2003	( CWinIniFile & ) const;

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	bool			itsRunning;
    bool			itsGameRunning;
	int				itsServerType;
	char *			itsServerName;
	char *			itsGameRoot;
	char *			itsExtraUccFlags;
	bool			itsUsesAdminName;
	char *			itsAdminName;
	char *			itsAdminPass;
	bool			itsUsesGamePass;
	char *			itsGamePass;
	bool			itsUsesWebAdmin;
	unsigned short	itsWebAdminPort;
	CFurserSrSetn_l	itsSettingList;
	CFurserSrEvnt_l	itsEventList;
	CFurserSrGrup_l	itsGroupList;
	CFurserSrUser_l	itsUserList;
	CFurserSrUban_l	itsBanList;
	CFurserSrMuta_l	itsMutatorList;
	CFurserSrGame_l	itsGameList;
	CFurserSrLevl_l	itsMapList;
    CFurserSrMacr_l	itsMacroList;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CFurserSrSrvr>		CFurserSrSrvr_l;
typedef CFurserSrSrvr_l::iterator       CFurserSrSrvr_li;
typedef CFurserSrSrvr_l::const_iterator	CFurserSrSrvr_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CFurserSrSrvr.h
// --------------------------------------------------------------------
