// --------------------------------------------------------------------
// CFurserSrUban.h
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserSrUban_h
#define CFurserSrUban_h

#include	"CFurserClient.h"
#include	"CWinIniFile.hxx"

// --------------------------------------------------------------------
class CFurserSrUban {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserSrUban	();
	~CFurserSrUban	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CFurserSrUban				( const CFurserSrUban & );
	CFurserSrUban & operator =	( const CFurserSrUban & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator == ( const CFurserSrUban & ) const;
	bool operator != ( const CFurserSrUban & ) const;
	bool operator == ( const char * ) const;
	bool operator != ( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void			Load		( CFurserClient & );
	void			Load		( const CWinIniFile &, const char * );
	void			Save		( CFurserClient & );
	void			Save		( CWinIniFile &, const char * );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *	BanName		( void ) const;
	bool			Enabled		( void ) const;
	int				BanType		( void ) const;
	const char *	BanArgs		( void ) const;

	// ----------------------------------------------------------------
	void			BanName		( const char * );
	void			Enabled		( bool );
	void			BanType		( int );
	void			BanArgs		( const char * );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			Free		( void );
	void			Cleanup		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *			itsBanName;
	bool			itsEnabled;
	int				itsBanType;
	char *			itsBanArgs;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CFurserSrUban>		CFurserSrUban_l;
typedef CFurserSrUban_l::iterator       CFurserSrUban_li;
typedef CFurserSrUban_l::const_iterator	CFurserSrUban_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CFurserSrUban.h
// --------------------------------------------------------------------
