// --------------------------------------------------------------------
// CFurserWizQery.h
// Whatis:  Furser Document class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#ifndef CFurserWizQery_h
#define CFurserWizQery_h

#include	"CWinIniFile.hxx"

// --------------------------------------------------------------------
typedef	enum {
	qerytype_string		= 0,
	qerytype_filename	= 1,
	qerytype_integer	= 2,
	qerytype_boolean	= 3,
	qerytype_float		= 4
}	qerytype_t;

// --------------------------------------------------------------------
class CFurserWizQery {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CFurserWizQery	();
	~CFurserWizQery	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CFurserWizQery				( const CFurserWizQery & );
	CFurserWizQery & operator =	( const CFurserWizQery & );

	// ----------------------------------------------------------------
	public:		// Interfaces
	// ----------------------------------------------------------------
	void			Load		( const CWinIniFile &, const char * );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *	Caption		( void ) const;
	const char *	Help		( void ) const;
	qerytype_t		Type		( void ) const;
	const char *	Min			( void ) const;
	const char *	Max			( void ) const;
	const char *	Default		( void ) const;
	const char *	Replaces	( void ) const;
	const char *	Value		( void ) const;

	// ----------------------------------------------------------------
	void			Value		( const char * );
	void			Check		( const char * );

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
	void		Free		( void );
	void		Cleanup		( void );
    qerytype_t	ResolveType	( const char * );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *		itsCaption;
	char *		itsHelp;
	qerytype_t	itsType;
	char *		itsMin;
	char *		itsMax;
	char *		itsDefault;
	char *		itsReplaces;
	char *		itsValue;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CFurserWizQery>			CFurserWizQery_l;
typedef CFurserWizQery_l::iterator			CFurserWizQery_li;
typedef CFurserWizQery_l::const_iterator	CFurserWizQery_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CFurserWizQery.h
// --------------------------------------------------------------------
