// --------------------------------------------------------------------
// CFurserSrEvnt.cpp
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"CFurserSrEvnt.h"
#include	"CError.hxx"

// --------------------------------------------------------------------
CFurserSrEvnt::CFurserSrEvnt	() {
	CFurserSrEvnt::Cleanup();
}

// --------------------------------------------------------------------
CFurserSrEvnt::~CFurserSrEvnt	() {
	CFurserSrEvnt::Free();
}

// --------------------------------------------------------------------
CFurserSrEvnt::CFurserSrEvnt	( const CFurserSrEvnt & aC ) {
	CFurserSrEvnt::Cleanup();
	*this = aC;
}

// --------------------------------------------------------------------
CFurserSrEvnt & CFurserSrEvnt::operator =	( const CFurserSrEvnt & aC ) {
	CFurserSrEvnt::Free();
	itsEventName	= ::my_private_strdup( aC.EventName() );
	itsEventType	= aC.EventType();
	itsEnabled		= aC.Enabled();
	itsStartTime	= aC.StartTime();
	itsStartTask	= aC.StartTask();
	itsEndTime		= aC.EndTime();
	itsEndTask		= aC.EndTask();
	return *this;
}

// --------------------------------------------------------------------
bool CFurserSrEvnt::operator == ( const CFurserSrEvnt & aC ) const {
	return *this == aC.EventName();
}

// --------------------------------------------------------------------
bool CFurserSrEvnt::operator != ( const CFurserSrEvnt & aC ) const {
	return *this != aC.EventName();
}

// --------------------------------------------------------------------
bool CFurserSrEvnt::operator == ( const char * aN ) const {
	return ::strcmp( CFurserSrEvnt::EventName(), aN ? aN : "" ) == 0;
}

// --------------------------------------------------------------------
bool CFurserSrEvnt::operator != ( const char * aN ) const {
	return ::strcmp( CFurserSrEvnt::EventName(), aN ? aN : "" ) != 0;
}

// --------------------------------------------------------------------
void	CFurserSrEvnt::Load	( CFurserClient & aC ) {
	CFurserSrEvnt::Free();
	try	{
		itsEventName	= aC.RxData();
		itsEventType	= aC.RxDataInt();
		itsEnabled		= aC.RxDataBool();
		itsStartTime	= aC.RxDataTime();
		itsStartTask	= aC.RxDataInt();
		itsEndTime		= aC.RxDataTime();
		itsEndTask		= aC.RxDataInt();
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrEvnt::Load", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrEvnt::Load", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrEvnt::Save	( CFurserClient & aC ) {
	try	{
		aC.TxResponse( CFurserSrEvnt::EventName() );
		aC.TxDataInt( itsEventType );
		aC.TxDataBool( itsEnabled );
		aC.TxDataTime( itsStartTime );
		aC.TxDataInt( itsStartTask );
		aC.TxDataTime( itsEndTime );
		aC.TxDataInt( itsEndTask );
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrEvnt::Save", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrEvnt::Save", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrEvnt::Load	( const CWinIniFile & aIni , const char * aSecName ) {
	CFurserSrEvnt::Free();
	itsEventName	= ::my_private_strdup( aIni.Value( aSecName, "EventName" ) );
	itsEventType	= aIni.IntValue( aSecName, "EventType" );
	itsEnabled		= aIni.BoolValue( aSecName, "Enabled" );
	itsStartTime	= aIni.IntValue( aSecName, "StartTime" );
	itsStartTask	= aIni.IntValue( aSecName, "StartTask" );
	itsEndTime		= aIni.IntValue( aSecName, "EndTime" );
	itsEndTask		= aIni.IntValue( aSecName, "EndTask" );
}

// --------------------------------------------------------------------
void	CFurserSrEvnt::Save	( CWinIniFile & aIni, const char * aSecName ) {
	CWinIniSection	sec;
	sec.Name( aSecName );
	sec.Insert( "EventName", CFurserSrEvnt::EventName() );
	sec.Insert( "EventType", itsEventType );
	sec.Insert( "Enabled", itsEnabled );
	sec.Insert( "StartTime", (int)itsStartTime );
	sec.Insert( "StartTask", itsStartTask );
	sec.Insert( "EndTime", (int)itsEndTime );
	sec.Insert( "EndTask", itsEndTask );
	aIni.Insert( sec );
}

// --------------------------------------------------------------------
const char *	CFurserSrEvnt::EventName	( void ) const {
	return	itsEventName ? itsEventName : "";
}

// --------------------------------------------------------------------
int		CFurserSrEvnt::EventType	( void ) const {
	return itsEventType;
}

// --------------------------------------------------------------------
bool	CFurserSrEvnt::Enabled		( void ) const {
	return itsEnabled;
}

// --------------------------------------------------------------------
time_t	CFurserSrEvnt::StartTime	( void ) const {
	return itsStartTime;
}

// --------------------------------------------------------------------
int		CFurserSrEvnt::StartTask	( void ) const {
	return itsStartTask;
}

// --------------------------------------------------------------------
time_t	CFurserSrEvnt::EndTime		( void ) const {
	return itsEndTime;
}

// --------------------------------------------------------------------
int		CFurserSrEvnt::EndTask		( void ) const {
	return itsEndTask;
}

// --------------------------------------------------------------------
void	CFurserSrEvnt::EventName	( const char * aV ) {
	if	( itsEventName ) delete [] itsEventName;
	itsEventName = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrEvnt::EventType	( int aV ) {
	itsEventType = aV;
}

// --------------------------------------------------------------------
void	CFurserSrEvnt::Enabled		( bool aV ) {
	if	( itsEventName ) {
    	if	( itsEventName[0] != 0 ) {
        	itsEventName[0] = aV ? '#' : '-';
        }
    }
	itsEnabled = aV;
}

// --------------------------------------------------------------------
void	CFurserSrEvnt::StartTime	( time_t aV ) {
	itsStartTime = aV;
}

// --------------------------------------------------------------------
void	CFurserSrEvnt::StartTask	( int aV ) {
	itsStartTask = aV;
}

// --------------------------------------------------------------------
void	CFurserSrEvnt::EndTime		( time_t aV ) {
	itsEndTime = aV;
}

// --------------------------------------------------------------------
void	CFurserSrEvnt::EndTask		( int aV ) {
	itsEndTask = aV;
}

// --------------------------------------------------------------------
void	CFurserSrEvnt::Free	( void ) {
	if	( itsEventName ) delete [] itsEventName;
	CFurserSrEvnt::Cleanup();
}

// --------------------------------------------------------------------
void	CFurserSrEvnt::Cleanup	( void ) {
	itsEventName	= NULL;
	itsEventType	= 0;
	itsEnabled		= false;
	itsStartTime	= (time_t)0;
	itsStartTask	= 0;
	itsEndTime		= (time_t)0;
	itsEndTask		= 0;
}

// --------------------------------------------------------------------
// EOF:	CFurserSrEvnt.cpp
// --------------------------------------------------------------------
