// --------------------------------------------------------------------
// CFurserSrGame.cpp
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"CFurserSrGame.h"
#include	"CError.hxx"

// --------------------------------------------------------------------
CFurserSrGame::CFurserSrGame	() {
	CFurserSrGame::Cleanup();
}

// --------------------------------------------------------------------
CFurserSrGame::~CFurserSrGame	() {
	CFurserSrGame::Free();
}

// --------------------------------------------------------------------
CFurserSrGame::CFurserSrGame	( const CFurserSrGame & aC ) {
	CFurserSrGame::Cleanup();
	*this = aC;
}

// --------------------------------------------------------------------
CFurserSrGame & CFurserSrGame::operator =	( const CFurserSrGame & aC ) {
	CFurserSrGame::Free();
	CFurserSrGame::MapPrefix( aC.MapPrefix() );
	CFurserSrGame::MapList( aC.MapList() );
	CFurserSrGame::GameName( aC.GameName() );
	CFurserSrGame::Description( aC.Description() );
	itsSettingList = aC.SettingList();
	return *this;
}

// --------------------------------------------------------------------
bool CFurserSrGame::operator == ( const CFurserSrGame & aC ) const {
	return *this == aC.GameName();
}

// --------------------------------------------------------------------
bool CFurserSrGame::operator != ( const CFurserSrGame & aC ) const {
	return *this != aC.GameName();
}

// --------------------------------------------------------------------
bool CFurserSrGame::operator == ( const char * aN ) const {
	return ::my_stricmp( CFurserSrGame::GameName(), aN ? aN : "" ) == 0;
}

// --------------------------------------------------------------------
bool CFurserSrGame::operator != ( const char * aN ) const {
	return ::my_stricmp( CFurserSrGame::GameName(), aN ? aN : "" ) != 0;
}

// --------------------------------------------------------------------
void	CFurserSrGame::Load	( CFurserClient & aC ) {
	dword_t	count, i;
	CFurserSrGame::Free();

    try {
		itsMapPrefix	= aC.RxData();
		itsMapList		= aC.RxData();
		itsGameName		= aC.RxData();
		itsDescription	= aC.RxData();

	    count = aC.RxDataDword();
    	for	( i = 0; i < count; i++ ) {
    		CFurserSrSetn mydata;
	        mydata.Load( aC );
    	    itsSettingList.push_back( mydata );
	    }
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrGame::Load", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrGame::Load", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrGame::Save	( CFurserClient & aC ) {
	try {
	    aC.TxResponse( CFurserSrGame::MapPrefix() );
	    aC.TxResponse( CFurserSrGame::MapList() );
	    aC.TxResponse( CFurserSrGame::GameName() );
    	aC.TxResponse( CFurserSrGame::Description() );

	    aC.TxDataDword( (dword_t)itsSettingList.size() );
    	for	( CFurserSrSetn_li loop = itsSettingList.begin(); loop != itsSettingList.end(); loop++ ) {
        	(*loop).Save( aC );
	    }
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrGame::Save", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrGame::Save", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrGame::Load	( const CWinIniFile & aIni, const char * aSecName ) {
	dword_t	count, i;
	char	secname[64];

	CFurserSrGame::Free();

	CFurserSrGame::MapPrefix( aIni.Value( aSecName, "MapPrefix" ) );
	CFurserSrGame::MapList( aIni.Value( aSecName, "MapList" ) );
	CFurserSrGame::GameName( aIni.Value( aSecName, "GameName" ) );
	CFurserSrGame::Description( aIni.Value( aSecName, "Description" ) );

    count = aIni.IntValue( aSecName, "SettingListCount" );
    for	( i = 0; i < count; i++ ) {
		::sprintf( secname, "%s.Setting_%d", aSecName, i );
    	CFurserSrSetn mydata;
        mydata.Load( aIni, secname );
        itsSettingList.push_back( mydata );
    }
}

// --------------------------------------------------------------------
void	CFurserSrGame::Save	( CWinIniFile & aIni, const char * aSecName ) {
	CWinIniSection	sec;
    dword_t			i;
	char			secname[64];

    sec.Name( aSecName );
	sec.Insert( "MapPrefix", CFurserSrGame::MapPrefix() );
	sec.Insert( "MapList", CFurserSrGame::MapList() );
	sec.Insert( "GameName", CFurserSrGame::GameName() );
	sec.Insert( "Description", CFurserSrGame::Description() );
	sec.Insert( "SettingListCount", (int)itsSettingList.size() );
	aIni.Insert( sec );

	i = 0;
    for	( CFurserSrSetn_li loop = itsSettingList.begin(); loop != itsSettingList.end(); loop++ ) {
		::sprintf( secname, "%s.Setting_%d", aSecName, i );
    	(*loop).Save( aIni, secname );
        i++;
    }
}

// --------------------------------------------------------------------
bool	CFurserSrGame::HasSetting	( const char * aN ) const {
	CFurserSrSetn_lci	loop;
    for	(	loop  = itsSettingList.begin();
    		loop != itsSettingList.end();
            loop++ ) {
    	if	( *loop == aN )	return true;
    }
    return false;
}

// --------------------------------------------------------------------
CFurserSrSetn	CFurserSrGame::GetSetting	( const char * aN ) const {
	CFurserSrSetn_lci	loop;
    for	(	loop  = itsSettingList.begin();
    		loop != itsSettingList.end();
            loop++ ) {
    	if	( *loop == aN )	return *loop;
    }
    CFurserSrSetn dummy;
    return dummy;
}

// --------------------------------------------------------------------
void	CFurserSrGame::SetSetting	( const char * aN, const CFurserSrSetn & aC ) {
	if	( ( ! CFurserSrGame::HasSetting( aC.SettingName() ) ) || ( aC == aN ) ) {
		CFurserSrSetn_li	loop;
    	for	(	loop  = itsSettingList.begin();
				loop != itsSettingList.end();
            	loop++ ) {
	    	if	( *loop == aN ) {
    	    	*loop = aC;
        	    break;
            }
        }
    }
}

// --------------------------------------------------------------------
void	CFurserSrGame::AddSetting	( const CFurserSrSetn & aC ) {
	if	( ! CFurserSrGame::HasSetting( aC.SettingName() ) ) {
    	itsSettingList.push_back( aC );
    }
}

// --------------------------------------------------------------------
void	CFurserSrGame::DelSetting	( const CFurserSrSetn & aC ) {
	itsSettingList.remove( aC );
}

// --------------------------------------------------------------------
const char *	CFurserSrGame::MapPrefix	( void ) const {
	return	itsMapPrefix ? itsMapPrefix : "";
}

// --------------------------------------------------------------------
const char *	CFurserSrGame::MapList	( void ) const {
	return	itsMapList ? itsMapList : "";
}

// --------------------------------------------------------------------
const char *	CFurserSrGame::GameName	( void ) const {
	return	itsGameName ? itsGameName : "";
}

// --------------------------------------------------------------------
const char *	CFurserSrGame::Description	( void ) const {
	return	itsDescription ? itsDescription : "";
}

// --------------------------------------------------------------------
const CFurserSrSetn_l &	CFurserSrGame::SettingList	( void ) const {
	return itsSettingList;
}

// --------------------------------------------------------------------
void	CFurserSrGame::MapPrefix	( const char * aV ) {
	if	( itsMapPrefix ) delete [] itsMapPrefix;
	itsMapPrefix = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrGame::MapList	( const char * aV ) {
	if	( itsMapList ) delete [] itsMapList;
	itsMapList = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrGame::GameName	( const char * aV ) {
	if	( itsGameName ) delete [] itsGameName;
	itsGameName = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrGame::Description	( const char * aV ) {
	if	( itsDescription ) delete [] itsDescription;
	itsDescription = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrGame::Free	( void ) {
	if	( itsMapPrefix )	delete [] itsMapPrefix;
	if	( itsMapList )		delete [] itsMapList;
	if	( itsGameName ) 	delete [] itsGameName;
	if	( itsDescription )	delete [] itsDescription;
	CFurserSrGame::Cleanup();
}

// --------------------------------------------------------------------
void	CFurserSrGame::Cleanup	( void ) {
	itsMapPrefix	= NULL;
	itsMapList		= NULL;
	itsGameName		= NULL;
	itsDescription	= NULL;
	itsSettingList.clear();
}

// --------------------------------------------------------------------
// EOF:	CFurserSrGame.cpp
// --------------------------------------------------------------------
