// --------------------------------------------------------------------
// CFurserSrGrup.cpp
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"CFurserSrGrup.h"
#include	"CError.hxx"

// --------------------------------------------------------------------
CFurserSrGrup::CFurserSrGrup	() {
	CFurserSrGrup::Cleanup();
}

// --------------------------------------------------------------------
CFurserSrGrup::~CFurserSrGrup	() {
	CFurserSrGrup::Free();
}

// --------------------------------------------------------------------
CFurserSrGrup::CFurserSrGrup	( const CFurserSrGrup & aC ) {
	CFurserSrGrup::Cleanup();
    *this = aC;
}

// --------------------------------------------------------------------
CFurserSrGrup & CFurserSrGrup::operator =	( const CFurserSrGrup & aC ) {
	CFurserSrGrup::Free();
	CFurserSrGrup::GroupName	( aC.GroupName() );
	CFurserSrGrup::Privileges	( aC.Privileges() );
	CFurserSrGrup::Comment		( aC.Comment() );
	itsGameSecLevel = aC.GameSecLevel();
    return *this;
}

// --------------------------------------------------------------------
bool CFurserSrGrup::operator == ( const CFurserSrGrup & aC ) const {
	return *this == aC.GroupName();
}

// --------------------------------------------------------------------
bool CFurserSrGrup::operator != ( const CFurserSrGrup & aC ) const {
	return *this != aC.GroupName();
}

// --------------------------------------------------------------------
bool CFurserSrGrup::operator == ( const char * aN ) const {
	return ::strcmp( CFurserSrGrup::GroupName(), aN ? aN : "" ) == 0;
}

// --------------------------------------------------------------------
bool CFurserSrGrup::operator != ( const char * aN ) const {
	return ::strcmp( CFurserSrGrup::GroupName(), aN ? aN : "" ) != 0;
}

// --------------------------------------------------------------------
// AdminGroups=(GroupName="serveradmin",Privileges="K|M|A|G|X",GameSecLevel=254)
// --------------------------------------------------------------------
char *	CFurserSrGrup::IniString( char * aS, size_t aR ) const {
    char				pr[3];
    const char *		ps;
    int					pc;

    ::sprintf( aS, "(GroupName=\"%s\"", CFurserSrGrup::GroupName() );

	// Output the privileges into the ini string
	::strcat( aS, ",Privileges=\"" );
    ps = CFurserSrGrup::Privileges();
    pc = 0;
	while	( *ps == '<' ) {
		ps++;
		pr[0] = *(ps++);
        if	( *ps != '>' ) {
           	pr[1] = *(ps++);
           	pr[2] = 0;
        }
        else {
           	pr[1] = 0;
        }
        if	( ::strlen( aS ) > (aR - 10) ) {
        	throw	CError( "String expands too long" );
        }
		if	( pc )	::strcat( aS, "|" );
		::strcat( aS, pr );
        pc++;
    	while	( ( *ps ) && ( *ps != '<' ) )	ps++;
    }

    // Rest of the stuff
    if	( ::strlen( aS ) > (aR - 20) ) {
       	throw	CError( "String expands too long" );
    }
	::sprintf( aS + ::strlen( aS ), "\",GameSecLevel=%i)", itsGameSecLevel );

	return	aS;
}

// --------------------------------------------------------------------
void	CFurserSrGrup::Load	( CFurserClient & aC ) {
	CFurserSrGrup::Free();
    try {
		itsGroupName	= aC.RxData();
		itsPrivileges	= aC.RxData();
		itsGameSecLevel	= aC.RxDataInt();
		itsComment		= aC.RxData();
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrGrup::Load", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrGrup::Load", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrGrup::Save	( CFurserClient & aC ) {
    try {
		aC.TxResponse( CFurserSrGrup::GroupName() );
		aC.TxResponse( CFurserSrGrup::Privileges() );
		aC.TxDataInt( itsGameSecLevel );
		aC.TxResponse( CFurserSrGrup::Comment() );
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrGrup::Save", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrGrup::Save", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrGrup::Load	( const CWinIniFile & aIni, const char * aSecName ) {
	CFurserSrGrup::Free();
	CFurserSrGrup::GroupName	( aIni.Value( aSecName, "GroupName" ) );
	CFurserSrGrup::Privileges	( aIni.Value( aSecName, "Privileges" ) );
	CFurserSrGrup::GameSecLevel	( (int)aIni.IntValue( aSecName, "GameSecLevel" ) );
	CFurserSrGrup::Comment		( aIni.Value( aSecName, "Comment" ) );
}

// --------------------------------------------------------------------
void	CFurserSrGrup::Save	( CWinIniFile & aIni, const char * aSecName ) {
	CWinIniSection	sec;
	sec.Name( aSecName );
	sec.Insert( "GroupName", 	CFurserSrGrup::GroupName() );
	sec.Insert( "Privileges", 	CFurserSrGrup::Privileges() );
	sec.Insert( "GameSecLevel", CFurserSrGrup::GameSecLevel() );
	sec.Insert( "Comment",		CFurserSrGrup::Comment() );
	aIni.Insert( sec );
}

// --------------------------------------------------------------------
bool	CFurserSrGrup::HasPrivilege	( const char * aP ) const {
	bool	result;
    char	mypriv[16];
	int		privlen = ::strlen( aP ? aP : "" );

    if		( itsPrivileges == NULL ) {
    	result = false;
    }
    else if	( privlen == 1 ) {
        ::sprintf( mypriv, "<%s>", aP );
        result = ::strstr( itsPrivileges, mypriv ) != NULL;
    }
    else if	( privlen == 2 ) {
        ::strcpy( mypriv, aP );
        mypriv[1] = 0;
        if	( CFurserSrGrup::HasPrivilege( mypriv ) ) {
        	result = true;
        }
        else {
	        ::sprintf( mypriv, "<%s>", aP );
    	    result = ::strstr( itsPrivileges, mypriv ) != NULL;
        }
    }
    else {
    	result = false;
    }

    return result;
}

// --------------------------------------------------------------------
void	CFurserSrGrup::AddPrivilege	( const char * aP ) {
	char *	mypriv;
	int		privlen = ::strlen( aP ? aP : "" );
	if	( ( privlen == 1 ) || ( privlen == 2 ) ) {
		CFurserSrGrup::DelPrivilege( aP );
		privlen	= privlen
        		+ ::strlen( CFurserSrGrup::Privileges() )
                + 3;
        mypriv	= new char [ privlen ];
        ::sprintf( mypriv, "%s<%s>", CFurserSrGrup::Privileges(), aP );
        if	( itsPrivileges )	delete [] itsPrivileges;
        itsPrivileges = mypriv;
    }
}

// --------------------------------------------------------------------
void	CFurserSrGrup::DelPrivilege	( const char * aP ) {
    char	mypriv[16];
    char *	pp;
	int		privlen = ::strlen( aP ? aP : "" );

    if		( ( itsPrivileges ) && ( privlen == 1 ) ) {
    	::sprintf( mypriv, "<%s", aP );
		pp = ::strstr( itsPrivileges, mypriv );
		while ( pp ) {
			if		( pp[2] == '>' ) {
	        	::strcpy( pp, pp + 3 );
            }
            else if	( pp[3] == '>' ) {
    	    	::strcpy( pp, pp + 4 );
            }
			pp = ::strstr( itsPrivileges, mypriv );
        }
    }
    else if	( ( itsPrivileges ) && ( privlen == 2 ) ) {
		::sprintf( mypriv, "<%s>", aP );
		pp = ::strstr( itsPrivileges, mypriv );
		while ( pp ) {
        	::strcpy( pp, pp + 4 );
			pp = ::strstr( itsPrivileges, mypriv );
        }
    }
}

// --------------------------------------------------------------------
const char *	CFurserSrGrup::GroupName	( void ) const {
	return itsGroupName ? itsGroupName : "";
}

// --------------------------------------------------------------------
const char *	CFurserSrGrup::Privileges	( void ) const {
	return itsPrivileges ? itsPrivileges : "";
}

// --------------------------------------------------------------------
int		CFurserSrGrup::GameSecLevel( void ) const {
	return itsGameSecLevel;
}

// --------------------------------------------------------------------
const char *	CFurserSrGrup::Comment	( void ) const {
	return itsComment ? itsComment : "";
}

// --------------------------------------------------------------------
void	CFurserSrGrup::GroupName	( const char * aV ) {
	if	( itsGroupName )	delete [] itsGroupName;
	itsGroupName = ::my_private_strdup( aV );
}

// -------------------------------------------------------------------
void	CFurserSrGrup::Privileges	( const char * aV ) {
	if	( itsPrivileges )	delete [] itsPrivileges;
	itsPrivileges = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrGrup::GameSecLevel( int aV ) {
	if	( aV < 0 )		aV = 0;
    if	( aV > 255 )	aV = 255;
	itsGameSecLevel = aV;
}

// -------------------------------------------------------------------
void	CFurserSrGrup::Comment	( const char * aV ) {
	if	( itsComment )	delete [] itsComment;
	itsComment = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrGrup::Free	( void ) {
	if	( itsGroupName )	delete [] itsGroupName;
	if	( itsPrivileges )	delete [] itsPrivileges;
	if	( itsComment )		delete [] itsComment;
	CFurserSrGrup::Cleanup();
}

// --------------------------------------------------------------------
void	CFurserSrGrup::Cleanup	( void ) {
	itsGroupName	= NULL;
	itsPrivileges	= NULL;
	itsComment		= NULL;
	itsGameSecLevel	= 0;
}

// --------------------------------------------------------------------
// EOF:	CFurserSrGrup.cpp
// --------------------------------------------------------------------
