// --------------------------------------------------------------------
// CFurserSrLevl.cpp
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"CFurserSrLevl.h"
#include	"CError.hxx"

// --------------------------------------------------------------------
CFurserSrLevl::CFurserSrLevl	() {
	CFurserSrLevl::Cleanup();
}

// --------------------------------------------------------------------
CFurserSrLevl::~CFurserSrLevl	() {
	CFurserSrLevl::Free();
}

// --------------------------------------------------------------------
CFurserSrLevl::CFurserSrLevl	( const CFurserSrLevl & aC ) {
	CFurserSrLevl::Cleanup();
	*this = aC;
}

// --------------------------------------------------------------------
CFurserSrLevl & CFurserSrLevl::operator =	( const CFurserSrLevl & aC ) {
	CFurserSrLevl::Free();
	CFurserSrLevl::MapName( aC.MapName() );
	CFurserSrLevl::GameClass( aC.GameClass() );
	itsRotate		= aC.Rotate();
	itsOrder		= aC.Order();
	return *this;
}

// --------------------------------------------------------------------
bool CFurserSrLevl::operator == ( const CFurserSrLevl & aC ) const {
	return *this == aC.MapName();
}

// --------------------------------------------------------------------
bool CFurserSrLevl::operator != ( const CFurserSrLevl & aC ) const {
	return *this != aC.MapName();
}

// --------------------------------------------------------------------
bool CFurserSrLevl::operator == ( const char * aN ) const {
	return ::strcmp( CFurserSrLevl::MapName(), aN ? aN : "" ) == 0;
}

// --------------------------------------------------------------------
bool CFurserSrLevl::operator != ( const char * aN ) const {
	return ::strcmp( CFurserSrLevl::MapName(), aN ? aN : "" ) != 0;
}

// --------------------------------------------------------------------
void	CFurserSrLevl::Load	( CFurserClient & aC ) {
	CFurserSrLevl::Free();

	try {
		itsMapName	= aC.RxData();
		itsGameClass= aC.RxData();
		itsRotate	= aC.RxDataBool();
		itsOrder	= aC.RxDataInt();
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrLevl::Load", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrLevl::Load", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrLevl::Save	( CFurserClient & aC ) {
	try {
	    aC.TxResponse( CFurserSrLevl::MapName() );
    	aC.TxResponse( CFurserSrLevl::GameClass() );
		aC.TxDataBool( itsRotate );
		aC.TxDataInt( itsOrder );
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrLevl::Save", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrLevl::Save", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrLevl::Load	( const CWinIniFile & aIni, const char * aSecName ) {
	CFurserSrLevl::Free();
	CFurserSrLevl::MapName( aIni.Value( aSecName, "MapName" ) );
	CFurserSrLevl::GameClass( aIni.Value( aSecName, "GameClass" ) );
	itsRotate	= aIni.BoolValue( aSecName, "Rotate" );
	itsOrder	= aIni.IntValue( aSecName, "Order" );
}

// --------------------------------------------------------------------
void	CFurserSrLevl::Save	( CWinIniFile & aIni, const char * aSecName ) {
	CWinIniSection	sec;

    sec.Name( aSecName );
	sec.Insert( "MapName", CFurserSrLevl::MapName() );
	sec.Insert( "GameClass", CFurserSrLevl::GameClass() );
	sec.Insert( "Rotate", itsRotate );
	sec.Insert( "Order", itsOrder );
	aIni.Insert( sec );
}

// --------------------------------------------------------------------
const char *	CFurserSrLevl::MapName		( void ) const {
	return itsMapName ? itsMapName : "";
}

// --------------------------------------------------------------------
const char *	CFurserSrLevl::GameClass		( void ) const {
	return itsGameClass ? itsGameClass : "";
}

// --------------------------------------------------------------------
bool	CFurserSrLevl::Rotate		( void ) const {
	return itsRotate;
}

// --------------------------------------------------------------------
int		CFurserSrLevl::Order		( void ) const {
	return itsOrder;
}

// --------------------------------------------------------------------
void	CFurserSrLevl::MapName	( const char * aV ) {
	if	( itsMapName ) delete [] itsMapName;
	itsMapName = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrLevl::GameClass	( const char * aV ) {
	if	( itsGameClass ) delete [] itsGameClass;
	itsGameClass = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrLevl::Rotate	( bool aV ) {
	itsRotate = aV;
}

// --------------------------------------------------------------------
void	CFurserSrLevl::Order	( int aV ) {
	itsOrder = aV;
}

// --------------------------------------------------------------------
void	CFurserSrLevl::Free	( void ) {
	if	( itsMapName ) delete [] itsMapName;
	if	( itsGameClass ) delete [] itsGameClass;
	CFurserSrLevl::Cleanup();
}

// --------------------------------------------------------------------
void	CFurserSrLevl::Cleanup	( void ) {
	itsMapName	= NULL;
	itsGameClass= NULL;
	itsRotate	= false;
	itsOrder	= 0;
}

// --------------------------------------------------------------------
// EOF:	CFurserSrLevl.cpp
// --------------------------------------------------------------------
