// --------------------------------------------------------------------
// CFurserSrMuta.cpp
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"CFurserSrMuta.h"
#include	"CError.hxx"

// --------------------------------------------------------------------
CFurserSrMuta::CFurserSrMuta	() {
	CFurserSrMuta::Cleanup();
}

// --------------------------------------------------------------------
CFurserSrMuta::~CFurserSrMuta	() {
	CFurserSrMuta::Free();
}

// --------------------------------------------------------------------
CFurserSrMuta::CFurserSrMuta	( const CFurserSrMuta & aC ) {
	CFurserSrMuta::Cleanup();
	*this = aC;
}

// --------------------------------------------------------------------
CFurserSrMuta & CFurserSrMuta::operator =	( const CFurserSrMuta & aC ) {
	CFurserSrMuta::Free();
	CFurserSrMuta::MutatorName( aC.MutatorName() );
	CFurserSrMuta::Description( aC.Description() );
	CFurserSrMuta::Group( aC.Group() );
	CFurserSrMuta::LoadFlag( aC.LoadFlag() );
	itsSettingList = aC.SettingList();
	return *this;
}

// --------------------------------------------------------------------
bool CFurserSrMuta::operator == ( const CFurserSrMuta & aC ) const {
	return *this == aC.MutatorName();
}

// --------------------------------------------------------------------
bool CFurserSrMuta::operator != ( const CFurserSrMuta & aC ) const {
	return *this != aC.MutatorName();
}

// --------------------------------------------------------------------
bool CFurserSrMuta::operator == ( const char * aN ) const {
	return	::strcmp( CFurserSrMuta::MutatorName(), aN ? aN : "" ) == 0;
}

// --------------------------------------------------------------------
bool CFurserSrMuta::operator != ( const char * aN ) const {
	return	::strcmp( CFurserSrMuta::MutatorName(), aN ? aN : "" ) != 0;
}

// --------------------------------------------------------------------
void	CFurserSrMuta::Load	( CFurserClient & aC ) {
	dword_t	count, i;
	CFurserSrMuta::Free();

	try {
		itsMutatorName	= aC.RxData();
	    itsDescription	= aC.RxData();
	    itsGroup		= aC.RxData();
    	itsLoadFlag     = aC.RxDataBool();

	    count = aC.RxDataDword();
    	for	( i = 0; i < count; i++ ) {
    		CFurserSrSetn mydata;
	        mydata.Load( aC );
    	    itsSettingList.push_back( mydata );
	    }
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrMuta::Load", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrMuta::Load", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrMuta::Save	( CFurserClient & aC ) {
	try {
	    aC.TxResponse( CFurserSrMuta::MutatorName() );
    	aC.TxResponse( CFurserSrMuta::Description() );
	    aC.TxResponse( CFurserSrMuta::Group() );
    	aC.TxDataBool( CFurserSrMuta::LoadFlag() );

	    aC.TxDataDword( (dword_t)itsSettingList.size() );
    	for	( CFurserSrSetn_li loop = itsSettingList.begin(); loop != itsSettingList.end(); loop++ ) {
        	(*loop).Save( aC );
	    }
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrMuta::Save", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrMuta::Save", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrMuta::Load	( const CWinIniFile & aIni, const char * aSecName ) {
	dword_t	count, i;
	char	secname[64];

	CFurserSrMuta::Free();

	CFurserSrMuta::MutatorName( aIni.Value( aSecName, "MutatorName" ) );
	CFurserSrMuta::Description( aIni.Value( aSecName, "Description" ) );
	CFurserSrMuta::Group	  ( aIni.Value( aSecName, "Group" ) );
	CFurserSrMuta::LoadFlag   ( aIni.BoolValue( aSecName, "LoadFlag" ) );

    count = aIni.IntValue( aSecName, "SettingListCount" );
    for	( i = 0; i < count; i++ ) {
		::sprintf( secname, "%s.Setting_%d", aSecName, i );
    	CFurserSrSetn mydata;
        mydata.Load( aIni, secname );
        itsSettingList.push_back( mydata );
    }
}

// --------------------------------------------------------------------
void	CFurserSrMuta::Save	( CWinIniFile & aIni, const char * aSecName ) {
	CWinIniSection	sec;
    dword_t			i;
	char			secname[64];

    sec.Name( aSecName );
	sec.Insert( "MutatorName", CFurserSrMuta::MutatorName() );
	sec.Insert( "Description", CFurserSrMuta::Description() );
	sec.Insert( "Group", 	   CFurserSrMuta::Group() );
	sec.Insert( "LoadFlag",    CFurserSrMuta::LoadFlag() );
	sec.Insert( "SettingListCount", (int)itsSettingList.size() );
	aIni.Insert( sec );

	i = 0;
    for	( CFurserSrSetn_li loop = itsSettingList.begin(); loop != itsSettingList.end(); loop++ ) {
		::sprintf( secname, "%s.Setting_%d", aSecName, i );
    	(*loop).Save( aIni, secname );
        i++;
    }
}

// --------------------------------------------------------------------
bool	CFurserSrMuta::HasSetting	( const char * aN ) const {
	CFurserSrSetn_lci	loop;
    for	(	loop  = itsSettingList.begin();
    		loop != itsSettingList.end();
            loop++ ) {
    	if	( *loop == aN )	return true;
    }
    return false;
}

// --------------------------------------------------------------------
CFurserSrSetn	CFurserSrMuta::GetSetting	( const char * aN ) const {
	CFurserSrSetn_lci	loop;
    for	(	loop  = itsSettingList.begin();
    		loop != itsSettingList.end();
            loop++ ) {
    	if	( *loop == aN )	return *loop;
    }
    CFurserSrSetn dummy;
    return dummy;
}

// --------------------------------------------------------------------
void	CFurserSrMuta::SetSetting	( const char * aN, const CFurserSrSetn & aC ) {
	if	( ( ! CFurserSrMuta::HasSetting( aC.SettingName() ) ) || ( aC == aN ) ) {
		CFurserSrSetn_li	loop;
    	for	(	loop  = itsSettingList.begin();
				loop != itsSettingList.end();
            	loop++ ) {
	    	if	( *loop == aN ) {
    	    	*loop = aC;
        	    break;
            }
        }
    }
}

// --------------------------------------------------------------------
void	CFurserSrMuta::AddSetting	( const CFurserSrSetn & aC ) {
	if	( ! CFurserSrMuta::HasSetting( aC.SettingName() ) ) {
    	itsSettingList.push_back( aC );
    }
}

// --------------------------------------------------------------------
void	CFurserSrMuta::DelSetting	( const CFurserSrSetn & aC ) {
	itsSettingList.remove( aC );
}

// --------------------------------------------------------------------
const char *	CFurserSrMuta::MutatorName	( void ) const {
	return	itsMutatorName ? itsMutatorName : "";
}

// --------------------------------------------------------------------
const char *	CFurserSrMuta::Description	( void ) const {
	return	itsDescription ? itsDescription : "";
}

// --------------------------------------------------------------------
const char *	CFurserSrMuta::Group	( void ) const {
	return	itsGroup ? itsGroup : "";
}

// --------------------------------------------------------------------
bool			CFurserSrMuta::LoadFlag	( void ) const {
	return	itsLoadFlag;
}

// --------------------------------------------------------------------
const CFurserSrSetn_l &	CFurserSrMuta::SettingList	( void ) const {
	return itsSettingList;
}

// --------------------------------------------------------------------
void	CFurserSrMuta::MutatorName	( const char * aV ) {
	if	( itsMutatorName ) delete [] itsMutatorName;
	itsMutatorName = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrMuta::Description	( const char * aV ) {
	if	( itsDescription ) delete [] itsDescription;
	itsDescription = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrMuta::Group	( const char * aV ) {
	if	( itsGroup ) delete [] itsGroup;
	itsGroup = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrMuta::LoadFlag		( bool aV ) {
	itsLoadFlag = aV;
}

// --------------------------------------------------------------------
void	CFurserSrMuta::Free	( void ) {
	if	( itsMutatorName ) delete [] itsMutatorName;
	if	( itsDescription ) delete [] itsDescription;
	if	( itsGroup ) 	   delete [] itsGroup;
	CFurserSrMuta::Cleanup();
}

// --------------------------------------------------------------------
void	CFurserSrMuta::Cleanup	( void ) {
	itsMutatorName	= NULL;
	itsDescription	= NULL;
	itsGroup    	= NULL;
	itsLoadFlag		= false;
	itsSettingList.clear();
}

// --------------------------------------------------------------------
// EOF:	CFurserSrMuta.cpp
// --------------------------------------------------------------------
