// --------------------------------------------------------------------
// CFurserSrUban.cpp
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"CFurserSrUban.h"
#include	"CError.hxx"

// --------------------------------------------------------------------
CFurserSrUban::CFurserSrUban	() {
	CFurserSrUban::Cleanup();
}

// --------------------------------------------------------------------
CFurserSrUban::~CFurserSrUban	() {
	CFurserSrUban::Free();
}

// --------------------------------------------------------------------
CFurserSrUban::CFurserSrUban	( const CFurserSrUban & aC ) {
	CFurserSrUban::Cleanup();
	*this = aC;
}

// --------------------------------------------------------------------
CFurserSrUban & CFurserSrUban::operator =	( const CFurserSrUban & aC ) {
	CFurserSrUban::Free();
	CFurserSrUban::BanName( aC.BanName() );
	CFurserSrUban::Enabled( aC.Enabled() );
	CFurserSrUban::BanType( aC.BanType() );
	CFurserSrUban::BanArgs( aC.BanArgs() );
	return *this;
}

// --------------------------------------------------------------------
bool CFurserSrUban::operator == ( const CFurserSrUban & aC ) const {
	return *this == aC.BanName();
}

// --------------------------------------------------------------------
bool CFurserSrUban::operator != ( const CFurserSrUban & aC ) const {
	return *this != aC.BanName();
}

// --------------------------------------------------------------------
bool CFurserSrUban::operator == ( const char * aN ) const {
	return ::strcmp( CFurserSrUban::BanName(), aN ? aN : "" ) == 0;
}

// --------------------------------------------------------------------
bool CFurserSrUban::operator != ( const char * aN ) const {
	return ::strcmp( CFurserSrUban::BanName(), aN ? aN : "" ) != 0;
}

// --------------------------------------------------------------------
void	CFurserSrUban::Load	( CFurserClient & aC ) {
	CFurserSrUban::Free();
	try {
		itsBanName	= aC.RxData();
		itsEnabled	= aC.RxDataBool();
		itsBanType	= aC.RxDataInt();
		itsBanArgs	= aC.RxData();
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrUban::Load", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrUban::Load", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrUban::Save	( CFurserClient & aC ) {
	try {
		aC.TxResponse( CFurserSrUban::BanName() );
		aC.TxDataBool( itsEnabled );
		aC.TxDataInt( itsBanType );
		aC.TxResponse( CFurserSrUban::BanArgs() );
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrUban::Save", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrUban::Save", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrUban::Load	( const CWinIniFile & aIni, const char * aSecName ) {
	CFurserSrUban::Free();
	CFurserSrUban::BanName( aIni.Value( aSecName, "BanName" ) );
	CFurserSrUban::Enabled( aIni.BoolValue( aSecName, "Enabled" ) );
	CFurserSrUban::BanType( aIni.IntValue( aSecName, "BanType" ) );
	CFurserSrUban::BanArgs( aIni.Value( aSecName, "BanArgs" ) );
}

// --------------------------------------------------------------------
void	CFurserSrUban::Save	( CWinIniFile & aIni, const char * aSecName ) {
	CWinIniSection	sec;
    sec.Name( aSecName );
	sec.Insert( "BanName", CFurserSrUban::BanName() );
	sec.Insert( "Enabled", CFurserSrUban::Enabled() );
	sec.Insert( "BanType", CFurserSrUban::BanType() );
	sec.Insert( "BanArgs", CFurserSrUban::BanArgs() );
	aIni.Insert( sec );
}

// --------------------------------------------------------------------
const char *	CFurserSrUban::BanName		( void ) const {
	return itsBanName ? itsBanName : "";
}

// --------------------------------------------------------------------
bool			CFurserSrUban::Enabled		( void ) const {
	return itsEnabled;
}

// --------------------------------------------------------------------
int				CFurserSrUban::BanType		( void ) const {
	return itsBanType;
}

// --------------------------------------------------------------------
const char *	CFurserSrUban::BanArgs		( void ) const {
	return itsBanArgs ? itsBanArgs : "";
}

// --------------------------------------------------------------------
void			CFurserSrUban::BanName		( const char * aV ) {
	if	( itsBanName ) delete [] itsBanName;
	itsBanName = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void			CFurserSrUban::Enabled		( bool aV ) {
	itsEnabled = aV;
}

// --------------------------------------------------------------------
void			CFurserSrUban::BanType		( int aV ) {
	if	( aV < 0 )	aV = 0;
    if	( aV > 1 )	aV = 1;
	itsBanType = aV;
}

// --------------------------------------------------------------------
void			CFurserSrUban::BanArgs		( const char * aV ) {
	if	( itsBanArgs ) delete [] itsBanArgs;
	itsBanArgs = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrUban::Free	( void ) {
	if	( itsBanName ) delete [] itsBanName;
	if	( itsBanArgs ) delete [] itsBanArgs;
	CFurserSrUban::Cleanup();
}

// --------------------------------------------------------------------
void	CFurserSrUban::Cleanup	( void ) {
	itsBanName = NULL;
	itsEnabled = false;
	itsBanType = 0;
	itsBanArgs = NULL;
}

// --------------------------------------------------------------------
// EOF:	CFurserSrUban.cpp
// --------------------------------------------------------------------
