// --------------------------------------------------------------------
// CFurserSrUser.cpp
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"CFurserSrUser.h"
#include	"CError.hxx"

// --------------------------------------------------------------------
CFurserSrUser::CFurserSrUser	() {
	CFurserSrUser::Cleanup();
}

// --------------------------------------------------------------------
CFurserSrUser::~CFurserSrUser	() {
	CFurserSrUser::Free();
}

// --------------------------------------------------------------------
CFurserSrUser::CFurserSrUser	( const CFurserSrUser & aC ) {
	CFurserSrUser::Cleanup();
	*this = aC;
}

// --------------------------------------------------------------------
CFurserSrUser & CFurserSrUser::operator =	( const CFurserSrUser & aC ) {
	CFurserSrUser::Free();
	CFurserSrUser::UserName( aC.UserName() );
	CFurserSrUser::UserPass( aC.UserPass() );
	CFurserSrUser::Enabled( aC.Enabled() );
	CFurserSrUser::Comment( aC.Comment() );
	itsGroupList = aC.GroupList();
	return *this;
}

// --------------------------------------------------------------------
bool CFurserSrUser::operator == ( const CFurserSrUser & aC ) const {
	return *this == aC.UserName();
}

// --------------------------------------------------------------------
bool CFurserSrUser::operator != ( const CFurserSrUser & aC ) const {
	return *this != aC.UserName();
}

// --------------------------------------------------------------------
bool CFurserSrUser::operator == ( const char * aN ) const {
	return ::strcmp( CFurserSrUser::UserName(), aN ? aN : "" ) == 0;
}

// --------------------------------------------------------------------
bool CFurserSrUser::operator != ( const char * aN ) const {
	return ::strcmp( CFurserSrUser::UserName(), aN ? aN : "" ) != 0;
}

// --------------------------------------------------------------------
int		CFurserSrUser::SecurityLevel	( void ) const {
	int					level = 0;
	CFurserSrGrup_lci	loop;
   	for	(	loop  = itsGroupList.begin();
			loop != itsGroupList.end();
           	loop++ ) {
    	if	( level < (*loop).GameSecLevel() ) {
        	level = (*loop).GameSecLevel();
        }
	}
	return	level;
}

// --------------------------------------------------------------------
// AdminUsers=
// (AdminName="UserName",Password="password",Privileges="K|M|A|G|X",Groups=
// ("serveradmin"),ManagedGroups=("serveradmin"))
// --------------------------------------------------------------------
char *	CFurserSrUser::IniString( char * aS, size_t aR ) const {
	CFurserSrGrup		grup;
    CFurserSrGrup_lci	gloo;
    char				pr[3];
    const char *		ps;
    int					pc;

	::sprintf(	aS, "(AdminName=\"%s\",Password=\"%s\",",
                CFurserSrUser::UserName(),
                CFurserSrUser::UserPass() );

    // Collect privileges from all the groups this user belongs to
    for	( gloo = itsGroupList.begin(); gloo != itsGroupList.end(); gloo++ ) {
		ps = (*gloo).Privileges();
        while	( *ps == '<' ) {
			ps++;
			pr[0] = *(ps++);
            if	( *ps != '>' ) {
            	pr[1] = *(ps++);
            	pr[2] = 0;
            }
            else {
            	pr[1] = 0;
            }
            grup.AddPrivilege( pr );

			while	( ( *ps ) && ( *ps != '<' ) )	ps++;
        }
	}

	// Output the privileges into the ini string
	::strcat( aS, "Privileges=\"" );
    ps = grup.Privileges();
    pc = 0;
	while	( *ps == '<' ) {
		ps++;
		pr[0] = *(ps++);
        if	( *ps != '>' ) {
           	pr[1] = *(ps++);
           	pr[2] = 0;
        }
        else {
           	pr[1] = 0;
        }
        if	( ::strlen( aS ) > (aR - 10) ) {
        	throw	CError( "String expands too long" );
        }
		if	( pc )	::strcat( aS, "|" );
		::strcat( aS, pr );
        pc++;
    	while	( ( *ps ) && ( *ps != '<' ) )	ps++;
    }

    // Groups
    if	( ::strlen( aS ) > (aR - 20) ) {
       	throw	CError( "String expands too long" );
    }
    ::strcat( aS, "\",Groups=(" );
    pc = 0;
    for	( gloo = itsGroupList.begin(); gloo != itsGroupList.end(); gloo++ ) {
        if	( ::strlen( aS ) > (aR - 10 - ::strlen( (*gloo).GroupName() ) ) ) {
        	throw	CError( "String expands too long" );
        }
    	if	( pc )	::strcat( aS, "," );
        ::strcat( aS, "\"" );
        ::strcat( aS, (*gloo).GroupName() );
        ::strcat( aS, "\"" );
	}

    // Rest of the stuff
    if	( ::strlen( aS ) > (aR - 20) ) {
       	throw	CError( "String expands too long" );
    }
	::strcat( aS, "),ManagedGroups=())" );

	return	aS;
}

// --------------------------------------------------------------------
void	CFurserSrUser::Load	( CFurserClient & aC ) {
	dword_t	count, i;
	CFurserSrUser::Free();

    try {
		itsUserName = aC.RxData();
		itsUserPass	= aC.RxData();
		itsEnabled	= aC.RxDataBool();
		itsComment	= aC.RxData();

	    count = aC.RxDataDword();
    	for	( i = 0; i < count; i++ ) {
    		CFurserSrGrup mydata;
	        mydata.Load( aC );
    	    itsGroupList.push_back( mydata );
	    }
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrUser::Load", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrUser::Load", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrUser::Save	( CFurserClient & aC ) {
    try {
		aC.TxResponse( CFurserSrUser::UserName() );
		aC.TxResponse( CFurserSrUser::UserPass() );
		aC.TxDataBool( itsEnabled );
		aC.TxResponse( CFurserSrUser::Comment() );
	    aC.TxDataDword( (dword_t)itsGroupList.size() );
    	for	( CFurserSrGrup_li loop = itsGroupList.begin(); loop != itsGroupList.end(); loop++ ) {
        	(*loop).Save( aC );
	    }
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrUser::Save", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrUser::Save", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrUser::Load	( const CWinIniFile & aIni, const char * aSecName ) {
	dword_t	count, i;
	char	secname[128];
	CFurserSrUser::Free();
	CFurserSrUser::UserName	( aIni.Value	( aSecName, "UserName" ) );
	CFurserSrUser::UserPass	( aIni.Value	( aSecName, "UserPass" ) );
	CFurserSrUser::Enabled	( aIni.BoolValue( aSecName, "Enabled" ) );
	CFurserSrUser::Comment	( aIni.Value	( aSecName, "Comment" ) );
    count = aIni.IntValue( aSecName, "GroupListCount" );
    for	( i = 0; i < count; i++ ) {
		::sprintf( secname, "%s.Group_%d", aSecName, i );
    	CFurserSrGrup mydata;
        mydata.Load( aIni, secname );
        itsGroupList.push_back( mydata );
    }
}

// --------------------------------------------------------------------
void	CFurserSrUser::Save	( CWinIniFile & aIni, const char * aSecName ) {
	CWinIniSection	sec;
    dword_t			i;
	char			secname[128];

    sec.Name( aSecName );
	sec.Insert( "UserName", CFurserSrUser::UserName() );
	sec.Insert( "UserPass", CFurserSrUser::UserPass() );
	sec.Insert( "Enabled",  CFurserSrUser::Enabled() );
	sec.Insert( "Comment",  CFurserSrUser::Comment() );
	sec.Insert( "GroupListCount", (int)itsGroupList.size() );
	aIni.Insert( sec );

	i = 0;
    for	( CFurserSrGrup_li loop = itsGroupList.begin(); loop != itsGroupList.end(); loop++ ) {
		::sprintf( secname, "%s.Group_%d", aSecName, i );
    	(*loop).Save( aIni, secname );
        i++;
    }
}

// --------------------------------------------------------------------
bool	CFurserSrUser::HasGroup	( const char * aN ) const {
	CFurserSrGrup_lci	loop;
    for	(	loop  = itsGroupList.begin();
    		loop != itsGroupList.end();
            loop++ ) {
    	if	( *loop == aN )	return true;
    }
    return false;
}

// --------------------------------------------------------------------
CFurserSrGrup	CFurserSrUser::GetGroup	( const char * aN ) const {
	CFurserSrGrup_lci	loop;
    for	(	loop  = itsGroupList.begin();
    		loop != itsGroupList.end();
            loop++ ) {
    	if	( *loop == aN )	return *loop;
    }
    CFurserSrGrup dummy;
    return dummy;
}

// --------------------------------------------------------------------
void	CFurserSrUser::SetGroup	( const char * aN, const CFurserSrGrup & aC ) {
	if	( ( ! CFurserSrUser::HasGroup( aC.GroupName() ) ) || ( aC == aN ) ) {
		CFurserSrGrup_li	loop;
    	for	(	loop  = itsGroupList.begin();
				loop != itsGroupList.end();
            	loop++ ) {
	    	if	( *loop == aN ) {
    	    	*loop = aC;
        	    break;
            }
        }
    }
}

// --------------------------------------------------------------------
void	CFurserSrUser::AddGroup	( const CFurserSrGrup & aC ) {
	if	( ! CFurserSrUser::HasGroup( aC.GroupName() ) ) {
    	itsGroupList.push_back( aC );
    }
}

// --------------------------------------------------------------------
void	CFurserSrUser::DelGroup	( const CFurserSrGrup & aC ) {
	itsGroupList.remove( aC );
}

// --------------------------------------------------------------------
void	CFurserSrUser::ClearGroups	( void ) {
	itsGroupList.clear();
}

// --------------------------------------------------------------------
const char *	CFurserSrUser::UserName	( void ) const {
	return itsUserName ? itsUserName : "";
}

// --------------------------------------------------------------------
const char *	CFurserSrUser::UserPass	( void ) const {
	return itsUserPass ? itsUserPass : "";
}

// --------------------------------------------------------------------
bool	CFurserSrUser::Enabled	( void ) const {
	return itsEnabled;
}

// --------------------------------------------------------------------
const char *	CFurserSrUser::Comment	( void ) const {
	return itsComment ? itsComment : "";
}

// --------------------------------------------------------------------
const CFurserSrGrup_l &	CFurserSrUser::GroupList( void ) const {
	return itsGroupList;
}

// --------------------------------------------------------------------
void	CFurserSrUser::UserName	( const char * aV ) {
	if	( itsUserName ) delete [] itsUserName;
	itsUserName = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrUser::UserPass	( const char * aV ) {
	if	( itsUserPass ) delete [] itsUserPass;
	itsUserPass = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrUser::Enabled	( bool aV ) {
	itsEnabled = aV;
}

// --------------------------------------------------------------------
void	CFurserSrUser::Comment	( const char * aV ) {
	if	( itsComment ) delete [] itsComment;
	itsComment = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrUser::Free	( void ) {
	if	( itsUserName ) delete [] itsUserName;
	if	( itsUserPass ) delete [] itsUserPass;
	if	( itsComment ) 	delete [] itsComment;
	CFurserSrUser::Cleanup();
}

// --------------------------------------------------------------------
void	CFurserSrUser::Cleanup	( void ) {
	itsUserName	= NULL;
	itsUserPass	= NULL;
	itsEnabled	= false;
	itsComment	= NULL;
	itsGroupList.clear();
}

// --------------------------------------------------------------------
// EOF:	CFurserSrUser.cpp
// --------------------------------------------------------------------
