// --------------------------------------------------------------------
// CFurserString.cpp
// Whatis:  Furser String class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"CFurserString.h"

// --------------------------------------------------------------------
CFurserString::CFurserString () {
	CFurserString::Cleanup();
}

// --------------------------------------------------------------------
CFurserString::CFurserString ( const char * aV ) {
	CFurserString::Cleanup();
	*this = aV;
}

// --------------------------------------------------------------------
CFurserString::~CFurserString () {
	CFurserString::Free();
}

// --------------------------------------------------------------------
CFurserString::CFurserString				( const CFurserString & aC ) {
	CFurserString::Cleanup();
	*this = aC;
}

// --------------------------------------------------------------------
CFurserString & CFurserString::operator =	( const CFurserString & aC ) {
	CFurserString::Free();
	itsString	= ::my_private_strdup( aC.c_str() );
	itsChecked	= aC.Checked();
	return *this;
}

// --------------------------------------------------------------------
CFurserString & CFurserString::operator =	( const char * aV ) {
	CFurserString::Free();
	itsString	= ::my_private_strdup( aV );
	return *this;
}

// --------------------------------------------------------------------
bool CFurserString::operator == ( const CFurserString & aC ) const {
	return *this == aC.c_str();
}

// --------------------------------------------------------------------
bool CFurserString::operator != ( const CFurserString & aC ) const {
	return *this != aC.c_str();
}

// --------------------------------------------------------------------
bool CFurserString::operator == ( const char * aV ) const {
	return	::strcmp( CFurserString::c_str(), aV ? aV : "" ) == 0;
}

// --------------------------------------------------------------------
bool CFurserString::operator != ( const char * aV ) const {
	return	::strcmp( CFurserString::c_str(), aV ? aV : "" ) != 0;
}

// --------------------------------------------------------------------
const char *	CFurserString::c_str	( void ) const {
	return	itsString ? itsString : "";
}

// --------------------------------------------------------------------
bool			CFurserString::Checked	( void ) const {
	return itsChecked;
}

// --------------------------------------------------------------------
void			CFurserString::Checked	( bool aV ) {
	itsChecked = aV;
}

// --------------------------------------------------------------------
void	CFurserString::Free	( void ) {
	if	( itsString ) delete [] itsString;
	CFurserString::Cleanup();
}

// --------------------------------------------------------------------
void	CFurserString::Cleanup	( void ) {
	itsString	= NULL;
	itsChecked	= false;
}

// --------------------------------------------------------------------
// EOF:	CFurserString.cpp
// --------------------------------------------------------------------
