// --------------------------------------------------------------------
// CFurserTask.cpp
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"CFurserTask.h"

// --------------------------------------------------------------------
CFurserTask::CFurserTask	() {
	CFurserTask::Cleanup();
}

// --------------------------------------------------------------------
CFurserTask::~CFurserTask	() {
	CFurserTask::Free();
}

// --------------------------------------------------------------------
CFurserTask::CFurserTask	( const CFurserTask & aC ) {
	CFurserTask::Cleanup();
	*this = aC;
}

// --------------------------------------------------------------------
CFurserTask & CFurserTask::operator =	( const CFurserTask & aC ) {
	CFurserTask::Free();
	CFurserTask::Server( aC.Server() );
	CFurserTask::Running( aC.Running() );
	CFurserTask::UccBinary( aC.UccBinary() );
	CFurserTask::SysFolder( aC.SysFolder() );
	CFurserTask::CmdLine( aC.CmdLine() );
	CFurserTask::ProcessInfo( aC.ProcessInfo() );
    return *this;
}

// --------------------------------------------------------------------
bool CFurserTask::operator == ( const CFurserTask & aC ) const {
	return	::strcmp( CFurserTask::Server(), aC.Server() ) == 0;
}

// --------------------------------------------------------------------
bool CFurserTask::operator != ( const CFurserTask & aC ) const {
	return	::strcmp( CFurserTask::Server(), aC.Server() ) != 0;
}

// --------------------------------------------------------------------
const char *	CFurserTask::Server	( void ) const {
	return	itsServer ? itsServer : "";
}

// --------------------------------------------------------------------
bool	CFurserTask::Running	( void ) const {
	return	itsRunning;
}

// --------------------------------------------------------------------
const char *	CFurserTask::UccBinary	( void ) const {
	return	itsUccBinary ? itsUccBinary : "";
}

// --------------------------------------------------------------------
const char *	CFurserTask::SysFolder	( void ) const {
	return	itsSysFolder ? itsSysFolder : "";
}

// --------------------------------------------------------------------
const char *	CFurserTask::CmdLine	( void ) const {
	return	itsCmdLine ? itsCmdLine : "";
}

// --------------------------------------------------------------------
#ifdef	WIN32
const PROCESS_INFORMATION &	CFurserTask::ProcessInfo	( void ) const {
	return itsProcessInfo;
}
#else
#endif

// --------------------------------------------------------------------
void	CFurserTask::Server	( const char * aV ) {
	if	( itsServer )	delete [] itsServer;
	itsServer = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserTask::Running( bool aV ) {
	itsRunning = aV;
}

// --------------------------------------------------------------------
void	CFurserTask::UccBinary	( const char * aV ) {
	if	( itsUccBinary )	delete [] itsUccBinary;
	itsUccBinary = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserTask::SysFolder	( const char * aV ) {
	if	( itsSysFolder )	delete [] itsSysFolder;
	itsSysFolder = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserTask::CmdLine	( const char * aV ) {
	if	( itsCmdLine )	delete [] itsCmdLine;
	itsCmdLine = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
#ifdef	WIN32
void	CFurserTask::ProcessInfo( const PROCESS_INFORMATION & aV ) {
	::memcpy( &itsProcessInfo, &aV, sizeof(itsProcessInfo) );
}
#else
#endif

// --------------------------------------------------------------------
void	CFurserTask::Free	( void ) {
	if	( itsServer )		delete [] itsServer;
	if	( itsUccBinary )	delete [] itsUccBinary;
	if	( itsSysFolder )	delete [] itsSysFolder;
	if	( itsCmdLine )		delete [] itsCmdLine;
	CFurserTask::Cleanup();
}

// --------------------------------------------------------------------
void	CFurserTask::Cleanup( void ) {
	itsServer		= NULL;
    itsRunning		= false;
    itsUccBinary	= NULL;
    itsSysFolder	= NULL;
    itsCmdLine		= NULL;

#ifdef	WIN32
	::memset( &itsProcessInfo, 0, sizeof( itsProcessInfo ) );
#else
#endif
}

// --------------------------------------------------------------------
// EOF:	CFurserTask.cpp
// --------------------------------------------------------------------
