// --------------------------------------------------------------------
// FurserDaemonProcess.cpp
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"FurserDaemon.h"
#include	"CTcpSocket.hxx"

//---------------------------------------------------------------------------
// The process
//---------------------------------------------------------------------------
extern	void	FurserDaemonProcess	( void * ) {
	CTcpSocket *	client = NULL;
	CTcpSocket		listensock( socket_type_stream );

	FurserStatus.running++;
    FurserMutex = new CCpuMutex;
	::FurserLog( "THREAD+", "FurserDaemonProcess" );

	//-----------------------------------------------------------------------
	// Start the scheduler thread
	//-----------------------------------------------------------------------
    ::FurserStartThread( FurserScheduleThread, NULL );

	//-----------------------------------------------------------------------
	// Set up the listen sock
	//-----------------------------------------------------------------------
    try {
		listensock.Bind( FurserConfig.listenport );
        listensock.Listen();
    }
    catch ( ... ) {
		FurserStatus.error = "Could not create listen socket";
		::FurserLog( "ERROR", FurserStatus.error );
    }

	//-----------------------------------------------------------------------
	// Process loop. Will hang in here as long as aborted
	//-------------------------------+----------------------------------------
    while	( ! FurserStatus.abort ) {

		if	( ( FurserStatus.pause ) || ( FurserStatus.error ) ) {
        	SLEEP( 1000 );
            continue;
        }

		//-------------------------------------------------------------------
		// Collect incoming connections
		//-------------------------------------------------------------------
    	try	{
			::FurserLock();
			client = listensock.Accept();
			if	( client ) {
				::FurserLog( "CLIENT+", client->PeerAddr() );
            	if	( FurserStatus.clients >= FurserConfig.maxclients ) {
					::FurserLog( client->PeerAddr(), "Too many clients" );
					::FurserLog( "CLIENT-", client->PeerAddr() );
                	delete client;
                    client = NULL;
                }
                else {
				    ::FurserStartThread( FurserClientThread, client );
                }
				::FurserUnlock();
			}
            else {
				::FurserUnlock();
            	SLEEP( 100 );
            }
        }
		catch	( ... ) {
        	if	( client ) {
            	delete client;
            }
            client = NULL;
			::FurserUnlock();
		}
	}

    // Wait some time for my clients to vanish
    for	( int i = 0; i < 10; i++ ) {
    	if	( FurserStatus.clients == 0 )	break;
        SLEEP( 1000 );
    }

	::FurserLog( "THREAD-", "FurserDaemonProcess" );
    if	( FurserMutex )	delete FurserMutex;
    FurserMutex = NULL;
	FurserStatus.running--;
}

// --------------------------------------------------------------------
// EOF: FurserDaemonProcess.cpp
// --------------------------------------------------------------------
