// --------------------------------------------------------------------
// FurserThread.cpp
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"FurserDaemon.h"
#include	"CError.hxx"

//---------------------------------------------------------------------------
// local:	Thread data
//---------------------------------------------------------------------------
typedef	struct thread_data_s {
	void   	(*func)(void *);
	void *	data;
}	thread_data_t;


//---------------------------------------------------------------------------
// The thread function
//---------------------------------------------------------------------------
#ifdef	WIN32
static unsigned long __stdcall __MyThreadRunner ( void * aArg ) {
#else
static	void *			__MyThreadRunner ( void * aArg ) {
#endif
	thread_data_t *	mydata = (thread_data_t *)aArg;
	try {
    	mydata->func( mydata->data );
	}
	catch ( ... ) {
	}
	delete mydata;
	return	0;
}

//---------------------------------------------------------------------------
// Start a thread
//---------------------------------------------------------------------------
extern	void	FurserStartThread	( void (*aFunction)(void *), void * aData ) {
	try	{
		thread_data_t *	mydata;
		mydata = new thread_data_t;
		mydata->func = aFunction;
		mydata->data = aData;

#ifdef	WIN32
		unsigned long	thread_id = 0;
        ::FurserLock();
        ::CreateThread( NULL, 0, __MyThreadRunner, (LPVOID)mydata, 0, &thread_id );
#else
		pthread_t	mythread;
        ::FurserLock();
		::pthread_create( &mythread, NULL, __MyThreadRunner, (void *)mydata );
		::pthread_detach( mythread );
#endif
        ::FurserUnlock();
	}
	catch	( ... ) {
        ::FurserUnlock();
	}
}

// --------------------------------------------------------------------
// EOF: FurserThread.cpp
// --------------------------------------------------------------------
