// --------------------------------------------------------------------
// WinFurserDaemonConfig.cpp
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"FurserDaemon.h"
#include	"CWinIniFile.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// Locate config file directory
// --------------------------------------------------------------------
extern	void	FurserDaemonFindWinConfigDirectory( const char * aExeFile, const char * aOptDir ) {
	if	( ! FurserStatus.error ) {
		const char *	mycnf = ::getenv( "FURSERCONFDIR" );
		struct stat		mystat;
	    if		( mycnf ) {
			::strcpy( FurserConfig.configdir, mycnf );
	    }
        else if	( aOptDir ) {
        	::strcpy( FurserConfig.configdir, aOptDir );
        }
	    else if	( ::getenv( "SystemRoot" ) ) {
			::strcpy( FurserConfig.configdir, ::getenv( "SystemRoot" ) );
			::strcat( FurserConfig.configdir, "\\system32\\drivers\\etc\\FurserDaemon" );
			while	( ::stat( FurserConfig.configdir, &mystat ) ) {
				if	( FurserConfig.configdir[0] >= 'Z' )	break;
	        	FurserConfig.configdir[0]++;
	        }
        }
        else {
			::strcpy( FurserConfig.configdir, "C:\\WINNT\\system32\\drivers\\etc\\FurserDaemon" );
			while	( ::stat( FurserConfig.configdir, &mystat ) ) {
				if	( FurserConfig.configdir[0] >= 'Z' )	break;
	        	FurserConfig.configdir[0]++;
	        }
		    if	( ::stat( FurserConfig.configdir, &mystat ) ) {
				::strcpy( FurserConfig.configdir, "C:\\WINDOWS\\system32\\drivers\\etc\\FurserDaemon" );
				while	( ::stat( FurserConfig.configdir, &mystat ) ) {
					if	( FurserConfig.configdir[0] >= 'Z' )	break;
	        		FurserConfig.configdir[0]++;
		        }
			}
	    }
	    if		( ::stat( FurserConfig.configdir, &mystat ) ) {
			FurserStatus.error = "Config directory not found";
	    	if	( aExeFile ) {
				throw	CError( aExeFile, FurserConfig.configdir, ::strerror( errno ) );
	        }
	    }
	    else if	( ( mystat.st_mode & S_IFDIR ) == 0 ) {
			FurserStatus.error = "Config directory not found";
			if	( aExeFile ) {
				throw	CError( aExeFile, FurserConfig.configdir, "Not a directory" );
	        }
	    }
		else {
			::strcpy( FurserConfig.configfile, FurserConfig.configdir );
			::strcat( FurserConfig.configfile, "\\FurserDaemon.ini" );
			::strcpy( FurserConfig.logfile, FurserConfig.configdir );
			::strcat( FurserConfig.logfile, "\\FurserDaemon.log" );
			::strcpy( FurserConfig.serverfile, FurserConfig.configdir );
			::strcat( FurserConfig.serverfile, "\\Servers.ini" );
			if	( ::stat( FurserConfig.configfile, &mystat ) ) {
				FurserStatus.error = "Config file not found";
				if	( aExeFile ) {
					throw	CError( aExeFile, FurserConfig.configfile, ::strerror( errno ) );
	    	    }
			}
		}
	}
}

// --------------------------------------------------------------------
// Read configuration
// --------------------------------------------------------------------
extern	void	FurserDaemonReadWinFurserConfig( const char * aExeFile ) {
	if	( ! FurserStatus.error ) {
		CWinIniFile	inifile;
    	try	{
            inifile.Read( FurserConfig.configfile );
            FurserConfig.listenport = (unsigned short)inifile.IntValue( "FurserDaemon", "Port" );
            ::strcpy( FurserConfig.serverpass, inifile.Value( "FurserDaemon", "Pass" ) );
            FurserConfig.maxclients	= inifile.IntValue( "FurserDaemon", "MaxClients" );
            FurserConfig.maxlogfile	= inifile.IntValue( "FurserDaemon", "MaxLogFile" );
    	}
        catch ( CError e ) {
			FurserStatus.error = "Config file read failed";
        	if	( aExeFile ) {
				throw CError( aExeFile, e.Error() );
            }
        }
    	catch ( ... ) {
			FurserStatus.error = "Config file read failed";
        	if	( aExeFile ) {
				throw CError( aExeFile, "Unknown error" );
            }
	    }
    }
}

// --------------------------------------------------------------------
// Read configuration
// --------------------------------------------------------------------
extern	void	FurserDaemonReportWinSettings( const char * aExeFile ) {
	::printf( "Current settings for %s:\n", aExeFile );
    ::printf( "Config dir=%s\n", FurserConfig.configdir );
    ::printf( "Config file=%s\n", FurserConfig.configfile );
    ::printf( "Server file=%s\n", FurserConfig.serverfile );
    ::printf( "Log    file=%s\n", FurserConfig.logfile );
    ::printf( "Port=%d\n", FurserConfig.listenport );
    ::printf( "Pass='%s'\n", FurserConfig.serverpass );
    ::printf( "MaxClients=%d\n", FurserConfig.maxclients );
    ::printf( "MaxLogSize=%li\n", FurserConfig.maxlogfile );

	::printf( "\n\nCurrent status for %s:\n", aExeFile );
    ::printf( "Latest error=%s\n", FurserStatus.error ? FurserStatus.error : "No error" );
}

// --------------------------------------------------------------------
// EOF: WinFurserDaemonConfig.cpp
// --------------------------------------------------------------------
