// --------------------------------------------------------------------
// C3DPolyList.hxx
// Whatis:  3D modeling library atom
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 22-OCT-2002     Created this source
// --------------------------------------------------------------------
#ifndef C3DPolyList_hxx
#define C3DPolyList_hxx
#include	"C3DPolygon.hxx"

// --------------------------------------------------------------------
// Declaration of the class
// --------------------------------------------------------------------
class   C3DPolyList {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    C3DPolyList () {}

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~C3DPolyList() {}

    // ----------------------------------------------------------------
    public:     // Copy constructor and assignment operator
    // ----------------------------------------------------------------
	C3DPolyList				( const C3DPolyList & aPolygon ) {
		*this = aPolygon;
	}

    // ----------------------------------------------------------------
	C3DPolyList & operator = 	( const C3DPolyList & aPolyList ) {
		itsPolyList = aPolyList.PolyList();
		return *this;
	}

    // ----------------------------------------------------------------
	public:		// Interface
    // ----------------------------------------------------------------
	void	T3DParseFile( const char * aFile );

    // ----------------------------------------------------------------
    const C3DPolygon_l	&	PolyList( void ) const	{ return itsPolyList; }

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
	C3DPolygon_l		itsPolyList;

};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class C3DPolyList>		C3DPolyList_l;
typedef C3DPolyList_l::iterator       	C3DPolyList_li;
typedef C3DPolyList_l::const_iterator	C3DPolyList_lci;

#endif  // #ifdef  C3DPolyList_hxx
// --------------------------------------------------------------------
// EOF: C3DPolyList.hxx
// --------------------------------------------------------------------
