// --------------------------------------------------------------------
// C3DPolygon.hxx
// Whatis:  3D modeling library atom
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 21-OCT-2002     Created this source
// --------------------------------------------------------------------
#ifndef C3DPolygon_hxx
#define C3DPolygon_hxx
#include	"C3DVertex.hxx"

// --------------------------------------------------------------------
// Declaration of the class
// --------------------------------------------------------------------
class   C3DPolygon {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    C3DPolygon () {
    	Cleanup();
    }

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~C3DPolygon() {
    	Free();
    }

    // ----------------------------------------------------------------
    public:     // Copy constructor and assignment operator
    // ----------------------------------------------------------------
	C3DPolygon				( const C3DPolygon & aPolygon ) {
		Cleanup();
		*this = aPolygon;
	}

    // ----------------------------------------------------------------
	C3DPolygon & operator = 	( const C3DPolygon & aPolygon );

    // ----------------------------------------------------------------
	public:		// Interface
    // ----------------------------------------------------------------
	const char *		T3DParse( const char * aS );


    // ----------------------------------------------------------------
    const C3DVertex_l &	VertexList	( void )	const			{ return itsVertexList; }
    void				VertexList	( const C3DVertex_l & aVl )	{ itsVertexList = aVl; }

	const C3DVertex &	Origin		( void )	const			{ return itsOrigin; }
    void				Origin		( const C3DVertex   & aV  )	{ itsOrigin = aV; }

	const C3DVertex &	Normal		( void )	const			{ return itsNormal; }
    void				Normal		( const C3DVertex   & aV  )	{ itsNormal = aV; }

	const C3DVertex &	TextureU	( void )	const			{ return itsTextureU; }
    void				TextureU	( const C3DVertex   & aV  )	{ itsTextureU = aV; }

	const C3DVertex &	TextureV	( void )	const			{ return itsTextureV; }
    void				TextureV	( const C3DVertex   & aV  )	{ itsTextureV = aV; }

	int					PanU		( void ) 	const			{ return itsPanU; }
	void				PanU		( int aV )					{ itsPanU = aV; }

	int					PanV		( void ) 	const			{ return itsPanV; }
	void				PanV		( int aV )					{ itsPanV = aV; }

	const char *		Item		( void )	const			{ return itsItem ? itsItem : ""; }
	void				Item		( const char * aV );

	const char *		Texture		( void )	const			{ return itsTexture ? itsTexture : ""; }
	void				Texture		( const char * aV );

	dword_t				Flags		( void )	const			{ return itsFlags; }
	void				Flags		( dword_t aV )				{ itsFlags = aV; }

	int					Link		( void )	const			{ return itsLink; }
	void				Link		( int aV )					{ itsLink = aV; }


    // ----------------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------------
    const char *		T3DParseVal	( int &, const char *, const char * ) const;
    const char *		T3DParseVal	( dword_t &, const char *, const char * ) const;
    const char *		T3DParseVal	( char *&, const char *, const char * ) const;

    void				Cleanup	( void );
    void				Free	( void );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
	C3DVertex_l	itsVertexList;
	C3DVertex	itsOrigin;
	C3DVertex	itsNormal;
	C3DVertex	itsTextureU;
	C3DVertex	itsTextureV;
	int			itsPanU;
	int			itsPanV;
	char *		itsItem;
	char *		itsTexture;
	dword_t		itsFlags;
	int			itsLink;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class C3DPolygon>			C3DPolygon_l;
typedef C3DPolygon_l::iterator       	C3DPolygon_li;
typedef C3DPolygon_l::const_iterator	C3DPolygon_lci;

#endif  // #ifdef  C3DPolygon_hxx
// --------------------------------------------------------------------
// EOF: C3DPolygon.hxx
// --------------------------------------------------------------------
