// --------------------------------------------------------------------
// CPictureFilter.hxx
// Whatis:  Picture manipulation class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CPictureFilter_hxx
#define CPictureFilter_hxx
#include	"CPicturePixmap.hxx"

// --------------------------------------------------------------------
// Declaration of the class - used as interface for image filtering
// --------------------------------------------------------------------
class   CPictureFilter {

    // ----------------------------------------------------------------
    public:     // Constructor
    // ----------------------------------------------------------------
    CPictureFilter () {
    }

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
	virtual	~CPictureFilter() {
	}

    // ----------------------------------------------------------------
    public:		// Copy constructor and assignment operator
    // ----------------------------------------------------------------
	CPictureFilter				( const CPictureFilter & aPicture );
	CPictureFilter & operator = ( const CPictureFilter & aPicture );

    // ----------------------------------------------------------------
	public:		// Interface, pure virtual methods
    // ----------------------------------------------------------------
	virtual	void			Process	( CPicturePixmap & )	= 0;
};

#endif  // #ifdef  CPictureFilter_hxx
// --------------------------------------------------------------------
// EOF: CPictureFilter.hxx
// --------------------------------------------------------------------
