// --------------------------------------------------------------------
// CPictureFilterAlphaBlend.hxx
// Whatis:  Quantize the image to limited number of colours
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CPictureFilterAlphaBlend_hxx
#define CPictureFilterAlphaBlend_hxx
#include	"CPictureFilter.hxx"

// --------------------------------------------------------------------
// Declaration of the class - used as interface for image filtering
// --------------------------------------------------------------------
class   CPictureFilterAlphaBlend : public CPictureFilter {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CPictureFilterAlphaBlend ( const CPicturePixel & aBG ) {
		itsBG = aBG;
    }

    CPictureFilterAlphaBlend ( byte_t aR, byte_t aG, byte_t aB, byte_t aA ) {
		itsBG.RGBA( aR, aG, aB, aA );
    }

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
	~CPictureFilterAlphaBlend() {
	}

    // ----------------------------------------------------------------
    private:	// Copy constructor and assignment operator - illegal to use
    // ----------------------------------------------------------------
	CPictureFilterAlphaBlend				( const CPictureFilterAlphaBlend & aPicture );
	CPictureFilterAlphaBlend & operator =	( const CPictureFilterAlphaBlend & aPicture );

    // ----------------------------------------------------------------
	public:		// Interface, pure virtual methods
    // ----------------------------------------------------------------
	void			Process	( CPicturePixmap & aPixmap );

    // ----------------------------------------------------------------
	public:		// Other interfaces
    // ----------------------------------------------------------------
	CPicturePixel	BG	( void ) const { return itsBG; }
	void			BG	( const CPicturePixel & aBG ) {
		itsBG = aBG;
	}
	void			BG	( byte_t aR, byte_t aG, byte_t aB, byte_t aA ) {
		itsBG.RGBA( aR, aG, aB, aA );
    }

    // ----------------------------------------------------------------
	private:	// Instance data
    // ----------------------------------------------------------------
	CPicturePixel	itsBG;

};

#endif  // #ifdef  CPictureFilterAlphaBlend_hxx
// --------------------------------------------------------------------
// EOF: CPictureFilterAlphaBlend.hxx
// --------------------------------------------------------------------
