// --------------------------------------------------------------------
// CPictureFilterQuantize.hxx
// Whatis:  Quantize the image to limited number of colours
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
//								Reference:	Otto Milvang: An adaptive algorithm for color quantization.
//											Proceedings of the 5th Scandinavian Conference on Image Analysis.
// --------------------------------------------------------------------
#ifndef CPictureFilterQuantize_hxx
#define CPictureFilterQuantize_hxx
#include	"CPictureFilter.hxx"

// --------------------------------------------------------------------
// Declaration of the class - used as interface for image filtering
// --------------------------------------------------------------------
class   CPictureFilterQuantize : public CPictureFilter {

    // ----------------------------------------------------------------
    public:     // Constructor
    // ----------------------------------------------------------------
    CPictureFilterQuantize ( word_t aMaxColors );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
	~CPictureFilterQuantize();

    // ----------------------------------------------------------------
    private:	// Copy constructor and assignment operator - illegal to use
    // ----------------------------------------------------------------
	CPictureFilterQuantize				( const CPictureFilterQuantize & aPicture );
	CPictureFilterQuantize & operator = ( const CPictureFilterQuantize & aPicture );

    // ----------------------------------------------------------------
	public:		// Interface, pure virtual methods
    // ----------------------------------------------------------------
	void			Process	( CPicturePixmap & aPixmap );

    // ----------------------------------------------------------------
	public:		// Other interfaces
    // ----------------------------------------------------------------
	int				MaxColors	( void )	const	{ return itsMaxColors; }
	void			MaxColors	( int aM )			{ itsMaxColors = (word_t)aM; }

    // ----------------------------------------------------------------
	private:	// Private helpers
    // ----------------------------------------------------------------
    void			ClearBucket	( 	void * 			aBucket );
    void			SetExtent	( 	void * 			aBucket );
    void			SplitBucket	( 	CPicturePixel * aPixmap,
    								dword_t			aSize,
    								word_tp			aPicture,
    								word_t			aOldIndx,
    								word_t			aNewIndx,
    								void * 			aBuckets );

    // ----------------------------------------------------------------
	private:	// Instance data
    // ----------------------------------------------------------------
	word_t			itsMaxColors;

};

#endif  // #ifdef  CPictureFilterQuantize_hxx
// --------------------------------------------------------------------
// EOF: CPictureFilterQuantize.hxx
// --------------------------------------------------------------------
