// --------------------------------------------------------------------
// CPicturePixmap.hxx
// Whatis:  Picture class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CPicturePixmap_hxx
#define CPicturePixmap_hxx
#include	"CPicturePixel.hxx"

// --------------------------------------------------------------------
// Declaration of the class
// --------------------------------------------------------------------
class   CPicturePixmap {

    // ----------------------------------------------------------------
    public:     // Constructor
    // ----------------------------------------------------------------
    CPicturePixmap ();
    CPicturePixmap ( dword_t aW, dword_t aH );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CPicturePixmap();

    // ----------------------------------------------------------------
    public:     // Copy constructor and assignment operator
    // ----------------------------------------------------------------
	CPicturePixmap				( const CPicturePixmap & aPixmap );
	CPicturePixmap & operator = ( const CPicturePixmap & aPixmap );

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    dword_t					W		( void ) const { return itsW; }
    dword_t					H		( void ) const { return itsH; }

	CPicturePixel *			Pixmap	( void ) const { return itsPixmap; }
	CPicturePixel			Pixel	( dword_t aX, dword_t aY ) const;
	void					Pixel	( dword_t aX, dword_t aY, const CPicturePixel & aPx );
	void					Pixel	( dword_t aO, const CPicturePixel & aPx );
	void					Create	( dword_t aW, dword_t aH );

    // ----------------------------------------------------------------
    public:     // Some graphic primitives
    // ----------------------------------------------------------------
    void					Line	(	dword_t					aX1,
    									dword_t					aY1,
    									dword_t					aX2,
    									dword_t					aY2,
    									const CPicturePixel &	aFG );

    // ----------------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------------
	void				Cleanup	( void );
	void				Copy	( const CPicturePixel * );
	void				Free	( void );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    dword_t			itsW;			// Width in pixels
    dword_t			itsH;			// Height in pixels
	CPicturePixel *	itsPixmap;		// Pixels
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CPicturePixmap>			CPicturePixmap_l;
typedef CPicturePixmap_l::iterator			CPicturePixmap_li;
typedef CPicturePixmap_l::const_iterator	CPicturePixmap_lci;

#endif  // #ifdef  CPicturePixmap_hxx
// --------------------------------------------------------------------
// EOF: CPicturePixmap.hxx
// --------------------------------------------------------------------
