// --------------------------------------------------------------------
// CPictureSource.hxx
// Whatis:  Picture manipulation class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CPictureSource_hxx
#define CPictureSource_hxx
#include	"CPicturePixmap.hxx"

// --------------------------------------------------------------------
// Declaration of the class - used as interface for image transfers
// --------------------------------------------------------------------
class   CPictureSource {

    // ----------------------------------------------------------------
    public:     // Constructor
    // ----------------------------------------------------------------
    CPictureSource () {
    }

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
	virtual	~CPictureSource() {
	}

    // ----------------------------------------------------------------
    public:		// Copy constructor and assignment operator
    // ----------------------------------------------------------------
	CPictureSource				( const CPictureSource & aPicture );
	CPictureSource & operator = ( const CPictureSource & aPicture );

    // ----------------------------------------------------------------
	public:		// Interface, pure virtual methods
    // ----------------------------------------------------------------
	virtual	CPicturePixmap	Read	( void ) const				= 0;
	virtual	void			Write	( const CPicturePixmap & )	= 0;
};

#endif  // #ifdef  CPictureSource_hxx
// --------------------------------------------------------------------
// EOF: CPictureSource.hxx
// --------------------------------------------------------------------
