// --------------------------------------------------------------------
// CPictureSourceBMP.hxx
// Whatis:  BMP Picture manipulation class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CPictureSourceBMP_hxx
#define CPictureSourceBMP_hxx
#include	"CPictureSource.hxx"

// --------------------------------------------------------------------
// Declaration of the class - used as interface for image transfers
// --------------------------------------------------------------------
class   CPictureSourceBMP : public CPictureSource {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CPictureSourceBMP ( );
    CPictureSourceBMP ( const char * aBmpFile );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
	~CPictureSourceBMP();

    // ----------------------------------------------------------------
    public:		// Copy constructor and assignment operator
    // ----------------------------------------------------------------
	CPictureSourceBMP				( const CPictureSourceBMP & aPicture );
	CPictureSourceBMP & operator =	( const CPictureSourceBMP & aPicture );

    // ----------------------------------------------------------------
	public:		// Interface
    // ----------------------------------------------------------------
	CPicturePixmap	Read	( void ) const;
	void			Write	( const CPicturePixmap & );

	const char *	File	( void ) const { return itsFile; }
	void			File	( const char * aFile );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    char *			itsFile;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CPictureSourceBMP>		CPictureSourceBMP_l;
typedef CPictureSourceBMP_l::iterator       CPictureSourceBMP_li;
typedef CPictureSourceBMP_l::const_iterator	CPictureSourceBMP_lci;

#endif  // #ifdef  CPictureSourceBMP_hxx
// --------------------------------------------------------------------
// EOF: CPictureSourceBMP.hxx
// --------------------------------------------------------------------
