// --------------------------------------------------------------------
// CPictureSourceT3D.hxx
// Whatis:  3D Polygon picture manipulation class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 22-NOV-2002     Created this source
// --------------------------------------------------------------------
#ifndef CPictureSourceT3D_hxx
#define CPictureSourceT3D_hxx
#include	"CPictureSource.hxx"
#include	"C3DPolyList.hxx"

// --------------------------------------------------------------------
// Defines for setting the camera
// --------------------------------------------------------------------
#define	T3D_CAMERA_TOP		0
#define	T3D_CAMERA_LEFT		1
#define	T3D_CAMERA_FRONT	2

// --------------------------------------------------------------------
// Declaration of the class - used as interface for image transfers
// --------------------------------------------------------------------
class   CPictureSourceT3D : public CPictureSource {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CPictureSourceT3D (	const char * aT3Dfile );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
	~CPictureSourceT3D() {}

    // ----------------------------------------------------------------
    public:	// Copy constructor and assignment operator
    // ----------------------------------------------------------------
	CPictureSourceT3D ( const CPictureSourceT3D & aSource ) {
		*this = aSource;
	}

    // ----------------------------------------------------------------
	CPictureSourceT3D & operator =	( const CPictureSourceT3D & aSource ) {
		itsPolyList = aSource.PolyList();
		itsFactor	= aSource.Factor();
		itsFG		= aSource.FG();
		itsBG		= aSource.BG();
		itsCamera	= aSource.Camera();
		return *this;
	}

    // ----------------------------------------------------------------
	public:		// Interface
    // ----------------------------------------------------------------
	CPicturePixmap		Read	( void ) const;
	void				Write	( const CPicturePixmap & );
	const C3DPolyList &	PolyList( void ) const { return itsPolyList; }
	double				Factor	( void ) const { return itsFactor; }
	void				Factor	( double aF )  { itsFactor = aF; }

	CPicturePixel		BG		( void ) const { return itsBG; }
	CPicturePixel		FG		( void ) const { return itsFG; }

	void				BG		( const CPicturePixel & aP ) { itsBG = aP; }
	void				FG		( const CPicturePixel & aP ) { itsFG = aP; }

	dword_t				W		( void ) const;
	dword_t				H		( void ) const;

	int					Camera	( void ) const { return itsCamera; }
	void				Camera	( int aC )	   { itsCamera = aC; }

    // ----------------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------------
	double				WcP		( void ) const;
	double				HcP		( void ) const;

	void				DrawPolygon	(	CPicturePixmap &	aPixmap,
										double				aWc,
										double				aHc,
										const C3DPolygon &	aPolygon ) const;

	void				CalcCoords	(	dword_t &			aX,
										dword_t &			aY,
										double				aWc,
										double				aHc,
										const C3DVertex &	aVertex ) const;

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
	C3DPolyList		itsPolyList;
	double			itsFactor;
	CPicturePixel	itsBG;
	CPicturePixel	itsFG;
	int				itsCamera;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CPictureSourceT3D>		CPictureSourceT3D_l;
typedef CPictureSourceT3D_l::iterator       CPictureSourceT3D_li;
typedef CPictureSourceT3D_l::const_iterator	CPictureSourceT3D_lci;

#endif  // #ifdef  CPictureSourceT3D_hxx
// --------------------------------------------------------------------
// EOF: CPictureSourceT3D.hxx
// --------------------------------------------------------------------
