// --------------------------------------------------------------------
// CPictureFilterAlphaBlend.cxx
// Whatis:  Create color table and image map
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include	"CError.hxx"
#include	"CPictureFilterAlphaBlend.hxx"

// --------------------------------------------------------------------
// public:	The data processor
// --------------------------------------------------------------------
void	CPictureFilterAlphaBlend::Process	( CPicturePixmap & aPixmap ) {
	dword_t			x, y;
	word_t			ami, amb;
	CPicturePixel	pixel;

	for	( y = 0; y < aPixmap.H(); y++ ) {
		for	( x = 0; x < aPixmap.W(); x++ ) {
			pixel = aPixmap.Pixel( x, y );

			// Alpha multipliers
			ami = (word_t)pixel.A();
			amb = (word_t)(255 - ami);

			pixel.R( (byte_t)( (amb * itsBG.R() + ami * (word_t)pixel.R()) / 255 ) );
			pixel.G( (byte_t)( (amb * itsBG.G() + ami * (word_t)pixel.G()) / 255 ) );
			pixel.B( (byte_t)( (amb * itsBG.B() + ami * (word_t)pixel.B()) / 255 ) );

			aPixmap.Pixel( x, y, pixel );
		}
	}



}

// --------------------------------------------------------------------
// EOF: CPictureFilterAlphaBlend.cxx
// --------------------------------------------------------------------
