// --------------------------------------------------------------------
// CPictureFilterIndexed.cxx
// Whatis:  Create color table and image map
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include	"CError.hxx"
#include	"CPictureFilterIndexed.hxx"

// --------------------------------------------------------------------
// public:	The data processor
// --------------------------------------------------------------------
void	CPictureFilterIndexed::Process	( CPicturePixmap & aPixmap ) {
	CPicturePixel *		pixmap	= aPixmap.Pixmap();
	CPicturePixel_l		clist;
	CPicturePixel_li	cloop;
	dword_t				num_pixels	= aPixmap.H() * aPixmap.W();
	dword_t				i, p;

	// Do this for successive calls
	itsColors = 0;
	if	( itsImage ) 	delete [] itsImage;		itsImage 	= NULL;
	if	( itsPalette )	delete [] itsPalette;	itsPalette	= NULL;

	// Loop through the image collecting different colours into our color list
	for	( i = 0; i < num_pixels; i++ ) {
		for	( cloop = clist.begin(); cloop != clist.end(); cloop++ ) {
			if	( (*cloop) == pixmap[i] )	break;
		}
		if	( cloop == clist.end() ) {
			clist.push_back( pixmap[i] );
		}
		if	( clist.size() > 65535 ) {
			throw CError( "Too many colours" );
		}
	}

	// Convert the list into an indexable palette and destroy the list
	itsPalette = new CPicturePixel [ clist.size() ];
	for	( cloop = clist.begin(), i=0; cloop != clist.end(); cloop++, i++ ) {
		itsPalette[i] = *cloop;
	}
	itsColors = (word_t)clist.size();
	clist.clear();

	// Allocate the image and convert the pixels into palette indexes
	itsImage = new word_t [num_pixels];
	for	( i = 0; i < num_pixels; i++ ) {
		for	( p = 0; p < (dword_t)itsColors; p++ ) {
			if	( itsPalette[p] == pixmap[i] ) {
				itsImage[i] = (word_t)p;
				break;
			}
		}
	}
}

// --------------------------------------------------------------------
// EOF: CPictureFilterIndexed.cxx
// --------------------------------------------------------------------
