// --------------------------------------------------------------------
// CPicturePixmap.cxx
// Whatis:  Pixmap manipulation
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include	"CPicturePixmap.hxx"

// --------------------------------------------------------------------
// public:	Constructors
// --------------------------------------------------------------------
CPicturePixmap::CPicturePixmap () {
	CPicturePixmap::Cleanup();
}

// --------------------------------------------------------------------
CPicturePixmap::CPicturePixmap ( dword_t aW, dword_t aH ) {
	CPicturePixmap::Cleanup();
	try	{
		CPicturePixmap::Create( aW, aH );
	}
	catch ( ... ) {
		CPicturePixmap::Free();
	}
}

// --------------------------------------------------------------------
// public:	Destructor
// --------------------------------------------------------------------
CPicturePixmap::~CPicturePixmap() {
	CPicturePixmap::Free();
}

// --------------------------------------------------------------------
// public:	Copy constructor and assignment operator
// --------------------------------------------------------------------
CPicturePixmap::CPicturePixmap				( const CPicturePixmap & aPixmap ) {
	CPicturePixmap::Cleanup();
	try	{
		CPicturePixmap::Create( aPixmap.W(), aPixmap.H() );
		CPicturePixmap::Copy( aPixmap.Pixmap() );
	}
	catch	( ... ) {
		CPicturePixmap::Free();
	}
}

// --------------------------------------------------------------------
CPicturePixmap & CPicturePixmap::operator = ( const CPicturePixmap & aPixmap ) {
	CPicturePixmap::Free();
	CPicturePixmap::Create( aPixmap.W(), aPixmap.H() );
	CPicturePixmap::Copy( aPixmap.Pixmap() );
	return *this;
}

// --------------------------------------------------------------------
// public:	Interface
// --------------------------------------------------------------------
CPicturePixel	CPicturePixmap::Pixel	( dword_t aX, dword_t aY ) const {
	if	( ( itsPixmap ) && ( aX < itsW ) && ( aY < itsH ) ) {
		return	itsPixmap[ aX + itsW * aY ];
	}
	CPicturePixel tmp;
	return	tmp;
}

// --------------------------------------------------------------------
void	CPicturePixmap::Pixel	( dword_t aX, dword_t aY, const CPicturePixel & aPx ) {
	if	( ( itsPixmap ) && ( aX < itsW ) && ( aY < itsH ) ) {
		itsPixmap[ aX + itsW * aY ] = aPx;
	}
}

// --------------------------------------------------------------------
void	CPicturePixmap::Pixel	( dword_t aO, const CPicturePixel & aPx ) {
	if	( ( itsPixmap ) && ( aO < itsW * itsH ) ) {
		itsPixmap[ aO ] = aPx;
	}
}

// --------------------------------------------------------------------
// public:	Draw a line
// --------------------------------------------------------------------
void			CPicturePixmap::Line(	dword_t					aX1,
    									dword_t					aY1,
    									dword_t					aX2,
    									dword_t					aY2,
    									const CPicturePixel &	aFG ) {

	dword_t		xd	= aX1 > aX2 ? aX1 - aX2 : aX2 - aX1;
	dword_t		yd	= aY1 > aY2 ? aY1 - aY2 : aY2 - aY1;

	// We loop using the bigger difference
	if		( xd > yd ) {
		double	yf = (double)yd / (double)xd;
		dword_t	xs = aX1 > aX2 ? aX2 : aX1;
		dword_t	xe = aX1 > aX2 ? aX1 : aX2;
		dword_t	x, yo;

		if	( aX1 < aX2 ) {
			yo = aY1;
			if	( aY1 > aY2 )	yf = -yf;
		}
		else {
			yo = aY2;
			if	( aY2 > aY1 )	yf = -yf;
		}

		for	( x = xs; x <= xe; x++ ) {
			CPicturePixmap::Pixel( x, (dword_t)( (double)(x - xs) * yf ) + yo, aFG );
		}
	}

	else if	( yd > xd ) {
		double	xf = (double)xd / (double)yd;
		dword_t	ys = aY1 > aY2 ? aY2 : aY1;
		dword_t	ye = aY1 > aY2 ? aY1 : aY2;
		dword_t	y, xo;

		if	( aY1 < aY2 ) {
			xo = aX1;
			if	( aX1 > aX2 )	xf = -xf;
		}
		else {
			xo = aX2;
			if	( aX2 > aX1 )	xf = -xf;
		}

		for	( y = ys; y <= ye; y++ ) {
			CPicturePixmap::Pixel( (dword_t)( (double)(y - ys) * xf ) + xo, y, aFG );
		}
	}
}

// --------------------------------------------------------------------
// private:	Private helpers
// --------------------------------------------------------------------
void	CPicturePixmap::Cleanup	( void ) {
	itsW = 0;
	itsH = 0;
	itsPixmap = NULL;
}

// --------------------------------------------------------------------
void	CPicturePixmap::Create	( dword_t aW, dword_t aH ) {
	CPicturePixmap::Free();
	itsW = aW;
	itsH = aH;
	itsPixmap = new CPicturePixel [itsW * itsH];
}

// --------------------------------------------------------------------
void	CPicturePixmap::Copy	( const CPicturePixel * aPixmap ) {
	dword_t	i = 0;

	while	( i < itsW * itsH )	{
		itsPixmap[i] = aPixmap[i];
		i++;
	}
}

// --------------------------------------------------------------------
void	CPicturePixmap::Free	( void ) {
	if	( itsPixmap )	delete [] itsPixmap;
	CPicturePixmap::Cleanup();
}

// --------------------------------------------------------------------
// EOF: CPicturePixmap.cxx
// --------------------------------------------------------------------
