// -----------------------------------------------------------------------
// Part of the Channel Planning Tool
// Copyright (c) 2000 Sonera LTD
//
// Name     : CCpuMutex.hxx
// Authors  : Esko Ilola (EIL)
// 
// Purpose  : Thread mutex locking class
// History  : 15-FEB-2000   EIL Created this source
// -----------------------------------------------------------------------
#ifndef CCpuMutex_hxx
#define CCpuMutex_hxx
#include    "Platform.hxx"

// -----------------------------------------------------------------------
// The CCpuMutex class
// -----------------------------------------------------------------------
class   CCpuMutex {

    // -------------------------------------------------------------------
    public:     // Constructor and destructor
    // -------------------------------------------------------------------
    CCpuMutex    ( );
    ~CCpuMutex   ( );

    // -------------------------------------------------------------------
    public:     // Thread mutex management interface
    // -------------------------------------------------------------------
    void            Lock    ( void );
    void            Unlock  ( void );
    void            Reset   ( void );

    // -------------------------------------------------------------------
    private:    // Instance data
    // -------------------------------------------------------------------
#ifdef	WIN32
    CRITICAL_SECTION    itsMutexRec;
#else
	pthread_mutex_t		itsMutexRec;
#endif
    int                 itsMutexCount;
};

#endif  // #ifndef  CCpuMutex_hxx
// -----------------------------------------------------------------------
// EOF: CCpuMutex.hxx
// -----------------------------------------------------------------------
