// -----------------------------------------------------------------------
// Name     : CCpuMutex.cxx
// Authors  : Esko Ilola (EIL)
// 
// Purpose  : Thread mutex locking class
// History  : 14-FEB-2000   EIL Created this source
// -----------------------------------------------------------------------
#include    "CCpuMutex.hxx"

// -----------------------------------------------------------------------
// public:      Constructor
// -----------------------------------------------------------------------
CCpuMutex::CCpuMutex() {
    itsMutexCount = 0;
#ifdef	WIN32
    InitializeCriticalSection( &itsMutexRec );
#else
	::pthread_mutex_init( &itsMutexRec, NULL );
#endif
}

// -----------------------------------------------------------------------
// public:      Destructor
// -----------------------------------------------------------------------
CCpuMutex::~CCpuMutex() {
    Reset();
#ifdef	WIN32
    DeleteCriticalSection( &itsMutexRec );
#else
	::pthread_mutex_destroy( &itsMutexRec );
#endif
}

// -----------------------------------------------------------------------
// public:      Lock from other threads
// -----------------------------------------------------------------------
void            CCpuMutex::Lock         ( void ) {
#ifdef	WIN32
    EnterCriticalSection( &itsMutexRec );
#else
	::pthread_mutex_lock( &itsMutexRec );
#endif
    itsMutexCount++;
}

// -----------------------------------------------------------------------
// public:      Release for other threads
// -----------------------------------------------------------------------
void            CCpuMutex::Unlock        ( void ) {
    if  ( itsMutexCount > 0 ) {
        itsMutexCount--;
#ifdef	WIN32
        LeaveCriticalSection( &itsMutexRec );
#else
		::pthread_mutex_unlock( &itsMutexRec );
#endif
    }
}

// -----------------------------------------------------------------------
// public:      Reset all locks
// -----------------------------------------------------------------------
void            CCpuMutex::Reset   ( void ) {
    while   ( itsMutexCount > 0 )   Unlock();
}

// -----------------------------------------------------------------------
// EOF: CCpuMutex.cxx
// -----------------------------------------------------------------------
