// --------------------------------------------------------------------
// PlatTst.cxx
// Whatis:  Time printing
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "Platform.hxx"

// --------------------------------------------------------------------
// Days and months
// --------------------------------------------------------------------
static const char *    __weekday[] = {
    "Sun", "Mon", "Tue", "Wed", "Thu",
    "Fri", "Sat"
};

static const char *    __month[] = {
    "Jan", "Feb", "Mar", "Apr",
    "May", "Jun", "Jul", "Aug",
    "Sep", "Oct", "Nov", "Dec"
};

static  char    __loc_strbuf[120] = { 0 };

// --------------------------------------------------------------------
// public:      To make printf easier job
// --------------------------------------------------------------------
extern  const char *    my_time_string  ( time_t aTime ) {
    struct tm * tms = ::gmtime( &aTime );

    ::sprintf(  __loc_strbuf,
                "%s, %d. %s %d %s%d:%s%d:%s%d %s",
                __weekday[tms->tm_wday],
                tms->tm_mday,
                __month[tms->tm_mon],
                tms->tm_year + 1900,
                tms->tm_hour < 10 ? "0" : "", tms->tm_hour,
                tms->tm_min  < 10 ? "0" : "", tms->tm_min,
                tms->tm_sec  < 10 ? "0" : "", tms->tm_sec,
#ifdef	WIN32
                "GMT" );
#else
                tms->tm_zone );
#endif

    return  __loc_strbuf;
}

// --------------------------------------------------------------------
// EOF: PlatTst.cxx
// --------------------------------------------------------------------
