// --------------------------------------------------------------------
// CUdelDoc.h
// Whatis:  UnrDelete Document class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#ifndef CUdelDoc_h
#define CUdelDoc_h

#include	"CUdelProduct.h"
#include	"CCpuMutex.hxx"

// --------------------------------------------------------------------
class CUdelDoc {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CUdelDoc		();
	~CUdelDoc		();

	// ----------------------------------------------------------------
	private:	// Copy constructor and assignment operator are invalid
	// ----------------------------------------------------------------
	CUdelDoc				( const CUdelDoc & );
	CUdelDoc & operator =	( const CUdelDoc & );

	// ----------------------------------------------------------------
	public:		// Initialization
	// ----------------------------------------------------------------
    void		Initialize	( const char * );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
    const CUdelProduct_l &	Products	( void ) const;
    const char *			Message		( void ) const;
    void					Message		( const char * );
    void					Lock		( void );
    void					Unlock		( void );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CUdelProduct_l	itsProducts;
	const char *	itsMessage;
    CCpuMutex		itsMutex;

};

#endif
// --------------------------------------------------------------------
// EOF:	CUdelDoc.h
// --------------------------------------------------------------------
