// --------------------------------------------------------------------
// CUdelProduct.h
// Whatis:  UnrDelete Document class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#ifndef CUdelProduct_h
#define CUdelProduct_h

#include	"CUpString.h"
#include	"CWinIniFile.hxx"
#include	"CUdelXref.h"
#include	"CUnUtils.hxx"

class	CUdelDoc;

// --------------------------------------------------------------------
class CUdelProduct {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CUdelProduct		( const CWinIniFile &, const char *, CUdelDoc * );
	~CUdelProduct		();

	// ----------------------------------------------------------------
	public:	// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CUdelProduct				( const CUdelProduct & );
	CUdelProduct & operator =	( const CUdelProduct & );

	// ----------------------------------------------------------------
	public:		// Creating Xreference list
	// ----------------------------------------------------------------
    CUdelXref_l	Xref			( const CUpString_l & ) const;
	void		XrefSelect		( CUdelXref_l &, const char *, bool ) const;

	// ----------------------------------------------------------------
	public:		// Some interfaces
	// ----------------------------------------------------------------
    bool		IsDeny			( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
    bool				IsOkay		( void ) const;
    const CUpString &	Name		( void ) const;
    const CUpString &	Gameroot	( void ) const;
    const CUpString &	MapSuffix	( void ) const;
    const CUpString_l & PackSuffix  ( void ) const;
    const CUpString_l & FileSuffix  ( void ) const;
    const CUpString_l & Deny        ( void ) const;
    const CUpString_l & Path        ( void ) const;
    const CUpString_l & MapList     ( void ) const;
    const CUpString_l & PackList    ( void ) const;
    const CUpString_l & FileList    ( void ) const;
    const CUdelXref_l & XrefList    ( void ) const;

    void				Name		( const CUpString & );
    void				Gameroot	( const CUpString & );
    void				MapSuffix	( const CUpString & );
    void				PackSuffix  ( const CUpString_l & );
	void				FileSuffix  ( const CUpString_l & );
    void				Deny        ( const CUpString_l & );
    void				Path		( const CUpString_l & );
    void				MapList		( const CUpString_l & );
    void				PackList	( const CUpString_l & );
    void				FileList	( const CUpString_l & );
    void				XrefList	( const CUdelXref_l & );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void				ReadIniFile 	( const CWinIniFile &, const char * );
	void				ReadRegistry	( void );
	void				ReadGameInit	( void );
	void				ReadManifest	( void );
    void				FindPaths		( const char * );
    void				FindFiles		( void );
	void				CreateXrefList	( void );
    bool				IsMap			( const char * ) const;
    bool				IsPack			( const char * ) const;
    bool				IsFile			( const char * ) const;
    CUpString_l			NeedList		( const unr_package_tl & ) const;
    int					XrefCount		( const char * ) const;
    int					XrefCount		( const CUdelXref_l &, const char * ) const;

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
    bool		itsIsOkay;
	CUpString	itsName;
    CUpString	itsRegistry;
    CUpString	itsGameroot;
	CUpString	itsMapSuffix;
    CUpString_l	itsPackSuffix;
    CUpString_l	itsFileSuffix;
    CUpString_l	itsDeny;
    CUpString_l	itsPath;
    CUpString_l	itsMapList;
    CUpString_l itsPackList;
    CUpString_l	itsFileList;
	CUdelXref_l	itsXrefList;
    CUdelDoc *	itsDoc;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CUdelProduct>		CUdelProduct_l;
typedef CUdelProduct_l::iterator       	CUdelProduct_li;
typedef CUdelProduct_l::const_iterator	CUdelProduct_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CUdelProduct.h
// --------------------------------------------------------------------
