// --------------------------------------------------------------------
// CUdelDoc.cpp
// Whatis:  UnrDelete Document class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#include	"CUdelDoc.h"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CUdelDoc::CUdelDoc() {
	itsMessage = NULL;
}

// --------------------------------------------------------------------
CUdelDoc::~CUdelDoc() {
}

// --------------------------------------------------------------------
void	CUdelDoc::Initialize( const char * aExePath ) {
	try {
	   	struct		stat	mystat;
   		char		config	[512];
	   	char		drive	[16];
    	char		path	[256];
	   	char		fname	[256];
		CWinIniFile	ini;

		// First we clear everything
    	itsProducts.clear();

		// Load in the init file (executable name + upp extension)
		::fnsplit( aExePath, drive, path, fname, NULL );
	    ::fnmerge( config, drive, path, fname, ".ini" );
		if	( ::stat( config, &mystat ) == 0 ) {
			ini.Read( config );
	    }
    	else {
    		throw CError( config, ::strerror( errno ) );
	    }

	    // Set up each product found
		itsMessage = "Scanning ...";
		CWinIniItem_l	list;
		CWinIniItem_lci	loop;
    	list = ini.ItemList( "Products", "Name" );
		for	( loop = list.begin(); loop != list.end(); loop++ ) {
    		CUdelProduct	myproduct( ini, (*loop).Value(), this );
			if	( myproduct.IsOkay() ) {
		        itsProducts.push_back( myproduct );
    	    }
		}
		itsMessage = NULL;
    }

    catch	( ... ) {
		itsMessage = NULL;
        throw;
    }
}

// --------------------------------------------------------------------
const CUdelProduct_l &	CUdelDoc::Products	( void ) const {
	return itsProducts;
}

// --------------------------------------------------------------------
const char *	CUdelDoc::Message		( void ) const {
	return itsMessage;
}

// --------------------------------------------------------------------
void	   		CUdelDoc::Message		( const char * aV ) {
	itsMessage = aV;
}

// --------------------------------------------------------------------
void			CUdelDoc::Lock			( void ) {
	itsMutex.Lock();
}

// --------------------------------------------------------------------
void			CUdelDoc::Unlock		( void ) {
	itsMutex.Unlock();
}

// --------------------------------------------------------------------
// EOF:	CUdelDoc.cpp
// --------------------------------------------------------------------
