// --------------------------------------------------------------------
// CUdelProduct.cpp
// Whatis:  UnrDelete Document class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#include	"CUdelProduct.h"
#include	"CUnUtils.hxx"
#include	"CUnLevelInfo.hxx"
#include	"CUdelDoc.h"
#include	<Registry.hpp>

// --------------------------------------------------------------------
CUdelProduct::CUdelProduct		( const CWinIniFile & aIni, const char * aSect, CUdelDoc * aDoc ) {
	itsIsOkay = false;
    try {
    	itsDoc = aDoc;

	    itsDoc->Lock();
	    itsDoc->Message( "" );
	    itsDoc->Unlock();

		CUdelProduct::ReadIniFile( aIni, aSect );
		CUdelProduct::ReadRegistry();
	    CUdelProduct::ReadManifest();
	    CUdelProduct::FindPaths( itsGameroot.Value() );
	    CUdelProduct::FindFiles();
    	CUdelProduct::CreateXrefList();

	    itsDoc->Lock();
	    itsDoc->Message( "" );
	    itsDoc->Unlock();

        itsIsOkay = true;
    }
    catch ( ... ) {
	    itsDoc->Lock();
	    itsDoc->Message( "" );
	    itsDoc->Unlock();
    }
}

// --------------------------------------------------------------------
CUdelProduct::~CUdelProduct		() {
}

// --------------------------------------------------------------------
CUdelProduct::CUdelProduct				( const CUdelProduct & aV ) {
	itsName			= aV.Name();
	itsMapSuffix	= aV.MapSuffix();
    itsPackSuffix	= aV.PackSuffix();
    itsFileSuffix	= aV.FileSuffix();
    itsDeny			= aV.Deny();
    itsPath			= aV.Path();
    itsMapList		= aV.MapList();
    itsPackList     = aV.PackList();
    itsFileList     = aV.FileList();
    itsXrefList		= aV.XrefList();
}

// --------------------------------------------------------------------
CUdelProduct & CUdelProduct::operator =	( const CUdelProduct & aV ) {
	itsName			= aV.Name();
	itsMapSuffix	= aV.MapSuffix();
    itsPackSuffix	= aV.PackSuffix();
    itsFileSuffix	= aV.FileSuffix();
    itsDeny			= aV.Deny();
    itsPath			= aV.Path();
    itsMapList		= aV.MapList();
    itsPackList     = aV.PackList();
    itsFileList     = aV.FileList();
    itsXrefList		= aV.XrefList();
	return *this;
}

// --------------------------------------------------------------------
bool	CUdelProduct::IsOkay	( void ) const {
	return itsIsOkay;
}

// --------------------------------------------------------------------
const CUpString &	CUdelProduct::Name		( void ) const {
	return itsName;
}

// --------------------------------------------------------------------
const CUpString &	CUdelProduct::MapSuffix	( void ) const {
	return itsMapSuffix;
}

// --------------------------------------------------------------------
const CUpString_l & CUdelProduct::PackSuffix  ( void ) const {
	return itsPackSuffix;
}

// --------------------------------------------------------------------
const CUpString_l & CUdelProduct::FileSuffix  ( void ) const {
	return itsFileSuffix;
}

// --------------------------------------------------------------------
const CUpString_l & CUdelProduct::Deny        ( void ) const {
	return itsDeny;
}

// --------------------------------------------------------------------
const CUpString_l & CUdelProduct::Path        ( void ) const {
	return itsPath;
}

// --------------------------------------------------------------------
const CUpString_l & CUdelProduct::MapList        ( void ) const {
	return itsMapList;
}

// --------------------------------------------------------------------
const CUpString_l & CUdelProduct::PackList        ( void ) const {
	return itsPackList;
}

// --------------------------------------------------------------------
const CUpString_l & CUdelProduct::FileList        ( void ) const {
	return itsFileList;
}

// --------------------------------------------------------------------
const CUdelXref_l & CUdelProduct::XrefList        ( void ) const {
	return itsXrefList;
}

// --------------------------------------------------------------------
void	CUdelProduct::Name		( const CUpString & aV ) {
	itsName = aV;
}

// --------------------------------------------------------------------
void	CUdelProduct::MapSuffix	( const CUpString & aV ) {
	itsMapSuffix = aV;
}

// --------------------------------------------------------------------
void	CUdelProduct::PackSuffix  ( const CUpString_l & aV ) {
	itsPackSuffix = aV;
}

// --------------------------------------------------------------------
void	CUdelProduct::FileSuffix  ( const CUpString_l & aV ) {
	itsFileSuffix = aV;
}

// --------------------------------------------------------------------
void	CUdelProduct::Deny        ( const CUpString_l & aV ) {
	itsDeny = aV;
}

// --------------------------------------------------------------------
void	CUdelProduct::Path        ( const CUpString_l & aV ) {
	itsPath = aV;
}

// --------------------------------------------------------------------
void	CUdelProduct::MapList     ( const CUpString_l & aV ) {
	itsMapList = aV;
}

// --------------------------------------------------------------------
void	CUdelProduct::PackList    ( const CUpString_l & aV ) {
	itsPackList = aV;
}

// --------------------------------------------------------------------
void	CUdelProduct::FileList    ( const CUpString_l & aV ) {
	itsFileList = aV;
}

// --------------------------------------------------------------------
void	CUdelProduct::XrefList    ( const CUdelXref_l & aV ) {
	itsXrefList = aV;
}

// --------------------------------------------------------------------
void	CUdelProduct::ReadIniFile ( const CWinIniFile & aIni, const char * aSect ) {
	CWinIniItem_l	list;
	CWinIniItem_lci	loop;
    CUpString		mystring;

    // Read in the values from the ini file
	itsName.Read		( aIni, aSect, "Name" );
    itsRegistry.Read    ( aIni, aSect, "Registry" );
    itsGameroot.Read    ( aIni, aSect, "Gameroot" );
	itsMapSuffix.Read   ( aIni, aSect, "MapSuffix" );
}

// --------------------------------------------------------------------
void	CUdelProduct::ReadRegistry	( void ) {
	if		( itsGameroot != "" )	;
    else if	( itsRegistry == "" ) {
    	throw	1;
    }
    else {
	    TRegistry *	reg;
		reg = new TRegistry;
		try {
		    reg->RootKey = HKEY_LOCAL_MACHINE;
			if	( reg->OpenKeyReadOnly( itsRegistry.Value() ) ) {
				AnsiString	mypath;
    	        mypath = reg->ReadString( "Folder" );
        	    reg->CloseKey();
				itsGameroot.Value( mypath.c_str() );
	        }
    	}

		catch	( ... ) {
    	}
		delete reg;

        if	( itsGameroot == "" ) {
        	throw	1;
        }
    }
}

// --------------------------------------------------------------------
void	CUdelProduct::ReadManifest ( void ) {
	char			inifile[512];
	char			filepath[512];
	char			filename[512];
    char			filesuff[64];
    struct stat		mystat;
	CWinIniFile		ini;
	CWinIniItem_l	groups;
   	CWinIniItem_li	group;
	CWinIniItem_l	files;
   	CWinIniItem_li	file;
    CUpString_lci	deny;
    CUpString		mystring;

    // Add standard file names to my deny list
    mystring.Value( "manifest" );
    itsDeny.push_back( mystring );

    ::sprintf(	inifile, "%s\\System\\Manifest.ini",
                itsGameroot.Value() );

	ini.Read( inifile );

    // Get the installed groups
    groups = ini.ItemList( "Setup", "Group" );
    for	( group = groups.begin(); group != groups.end(); group++ ) {

 		// Each group has a bunch of files
		files =  ini.ItemList( (*group).Value(), "File" );

        // Add each file to our deny list
        for	( file = files.begin(); file != files.end(); file++ ) {

			// Does this file exist ?
            ::sprintf( filepath, "%s\\%s", itsGameroot.Value(), (*file).Value() );
			if	( ::stat( filepath, &mystat ) != 0 )	continue;

			// Add the name into deny list
		    ::fnsplit( filepath, NULL, NULL, filename, filesuff );
            ::strlwr( filename );
            ::strlwr( filesuff );
            if	( ! CUdelProduct::IsDeny( filename ) ) {
               	mystring.Value( filename );
               	itsDeny.push_back( mystring );
            }

            // Is this a map ?
			if	( CUdelProduct::IsMap( filepath ) )		continue;

            // Is this a pack ?
			if	( CUdelProduct::IsPack( filepath ) )	continue;

			// Is this a file ?
			if	( CUdelProduct::IsFile( filepath ) )	continue;

            // Let's see if it is an unreal pack
            bool	isunreal = false;
            try {
            	CUnFile		unf( filepath );
                isunreal = true;
            }
            catch ( ... ) {

            }

			// Now add the suffix to appropriate place
            mystring.Value( filesuff );
            if	( isunreal )	itsPackSuffix.push_back( mystring );
            else				itsFileSuffix.push_back( mystring );

		    itsDoc->Lock();
		    itsDoc->Message( 	isunreal
            					? itsPackSuffix.back().Value()
                                : itsFileSuffix.back().Value() );
		    itsDoc->Unlock();

        }
	}
}

// --------------------------------------------------------------------
void	CUdelProduct::FindPaths	( const char * aRoot ) {
	// Resursively add all directories starting from game root
	char		mywild[512];
	char		myfile[512];
    struct stat	mystat;
	CUpString	mystring;
	TSearchRec	sr;

    if	( ::stat( aRoot, &mystat ) != 0 )	throw	1;
    if	( (mystat.st_mode & S_IFDIR) == 0 )	throw	1;
    mystring.Value( aRoot );
    itsPath.push_back( mystring );

    itsDoc->Lock();
    itsDoc->Message( itsPath.back().Value() );
    itsDoc->Unlock();

	::sprintf( mywild, "%s\\*.*", aRoot );
	if	( FindFirst( mywild, faDirectory, sr ) == 0 ) {
    	do {
			if	( sr.Name == "." )	continue;
            if	( sr.Name == ".." )	continue;
			::sprintf( myfile, "%s\\%s", aRoot, sr.Name.c_str() );
		    if	( ::stat( myfile, &mystat ) != 0 )	throw	1;
		    if	( (mystat.st_mode & S_IFDIR) != 0 ) {
	            CUdelProduct::FindPaths( myfile );
            }
		}	while ( FindNext( sr ) == 0 );
	}
}

// --------------------------------------------------------------------
void	CUdelProduct::FindFiles	( void ) {
	CUpString_lci	loop;

    // Go through all paths
    for	( loop = itsPath.begin(); loop != itsPath.end(); loop++ ) {
		TSearchRec	sr;
    	char		wild[512];
        ::sprintf( wild, "%s\\*.*", (*loop).Value() );
	    if	( FindFirst( wild, faReadOnly|faHidden|faSysFile|faArchive, sr ) == 0 ) {
			CUpString 	mystring;
            struct stat mystat;
          	char		myfile[512];
			do {
				if	( sr.Name == "." )	continue;
                if	( sr.Name == ".." )	continue;
				::sprintf( myfile, "%s\\%s", (*loop).Value(), sr.Name.c_str() );
				mystring.Value( myfile );
				if		( ::stat( myfile, &mystat ) != 0 )	;
                else if	( (mystat.st_mode & S_IFREG) == 0 )	;
               	else if	( CUdelProduct::IsDeny( myfile ) )	;
                else if	( CUdelProduct::IsMap ( myfile ) ) {
                	itsMapList.push_back ( mystring );
				    itsDoc->Lock();
				    itsDoc->Message( itsMapList.back().Value() );
				    itsDoc->Unlock();
                }
                else if	( CUdelProduct::IsPack( myfile ) ) {
                	itsPackList.push_back( mystring );
				    itsDoc->Lock();
				    itsDoc->Message( itsPackList.back().Value() );
				    itsDoc->Unlock();
                }
                else if	( CUdelProduct::IsFile( myfile ) ) {
                	itsFileList.push_back( mystring );
				    itsDoc->Lock();
				    itsDoc->Message( itsFileList.back().Value() );
				    itsDoc->Unlock();
                }
                else {
					char	mysuff[64];
                   	bool	isunr;

                    ::fnsplit( myfile, NULL, NULL, NULL, mysuff );
                    ::strlwr( mysuff );
					mystring.Value( mysuff );

                    try {
                      	CUnFile		unf( myfile );
                        isunr = true;
                    }
                    catch ( ... ) {
                     	isunr = false;
                    }
                    if	( isunr )	itsPackSuffix.push_back( mystring );
                    else			itsFileSuffix.push_back( mystring );

					mystring.Value( myfile );
                    if	( isunr )	itsPackList.push_back( mystring );
                    else			itsFileList.push_back( mystring );
				    itsDoc->Message( 	isunr
        		    					? itsPackList.back().Value()
                		                : itsFileList.back().Value() );
                }
            }	while ( FindNext( sr ) == 0 );
			FindClose( sr );
        }
    }
}

// --------------------------------------------------------------------
bool	CUdelProduct::IsDeny	( const char * aPath ) const {
	CUpString_lci	loop;
    char			name[512];

    ::fnsplit( aPath, NULL, NULL, name, NULL );
    ::strlwr( name );
    for ( loop = itsDeny.begin(); loop != itsDeny.end(); loop++ ) {
    	if	( (*loop) == name )	return true;
    }
	return false;
}

// --------------------------------------------------------------------
bool	CUdelProduct::IsMap	( const char * aPath ) const {
    char			suff[512];
    ::fnsplit( aPath, NULL, NULL, NULL, suff );
    return ::stricmp( itsMapSuffix.Value(), suff ) == 0;
}

// --------------------------------------------------------------------
bool	CUdelProduct::IsPack ( const char * aPath ) const {
	CUpString_lci	loop;
    char			suff[512];

    ::fnsplit( aPath, NULL, NULL, NULL, suff );
    ::strlwr( suff );
    if	( ! ::strcmp( suff, ".ogg" ) )	return true;
    for ( loop = itsPackSuffix.begin(); loop != itsPackSuffix.end(); loop++ ) {
    	if	( ! ::strcmp( suff, (*loop).Value() ) )	return true;
    }
	return false;
}

// --------------------------------------------------------------------
bool	CUdelProduct::IsFile ( const char * aPath ) const {
	CUpString_lci	loop;
    char			suff[512];

    ::fnsplit( aPath, NULL, NULL, NULL, suff );
    ::strlwr( suff );
    for ( loop = itsFileSuffix.begin(); loop != itsFileSuffix.end(); loop++ ) {
    	if	( ! ::strcmp( suff, (*loop).Value() ) )	return true;
    }
	return false;
}

// --------------------------------------------------------------------
void	CUdelProduct::CreateXrefList ( void ) {
	CUpString_lci	loop;
	CUdelXref		xref;
	CUdelXref_li	item;

	// Include maps
	for	( loop = itsMapList.begin(); loop != itsMapList.end(); loop++ ) {
    	xref.Name( *loop );
        itsXrefList.push_back( xref );
    }

	// Include packs
	for	( loop = itsPackList.begin(); loop != itsPackList.end(); loop++ ) {
    	xref.Name( *loop );
        itsXrefList.push_back( xref );
    }

    // Browse the xrefs through creating xref list for each - only packs at this time
	for	( item = itsXrefList.begin(); item != itsXrefList.end(); item++ ) {
	    itsDoc->Lock();
	    itsDoc->Message( (*item).Name().Value() );
	    itsDoc->Unlock();
    	try	{
			// Add normal needs for this pack
			CUnUtils		util( (*item).Name().Value() );
			unr_package_tl	need = util.ImportList();

			// If it happens to be a map there may be a chance it needs *.ogg
            if	( CUdelProduct::IsMap( (*item).Name().Value() ) ) {
            	try	{
					CUnFile			unf( (*item).Name().Value() );
    	            CUnNameTable    ntb( unf );
        	        CUnExportTable	etb( unf );
            	    CUnImportTable	itb( unf );
                	CUnLevelInfo	lvl( unf, ntb, etb, itb );
	                if	( lvl.Audio()[0] != 0 ) {
						unr_package_t	package;
        	            ::strcpy( package.name, lvl.Audio() );
            	        need.push_back( package );
                	}
                }
				catch ( ... ) {
                }
            }
			(*item).Need( CUdelProduct::NeedList( need ) );
        }
        catch	( ... ) {
        }
    }
}

// --------------------------------------------------------------------
CUpString_l	CUdelProduct::NeedList ( const unr_package_tl & aNeedList ) const {
	CUpString_l			list;
	CUpString_lci		loop;
    unr_package_tlci    need;
	char				myname[512];

	// First add normal packages to the need list
    for	( loop = itsPackList.begin(); loop != itsPackList.end(); loop++ ) {
        ::fnsplit( (*loop).Value(), NULL, NULL, myname, NULL );
		for	( need = aNeedList.begin(); need != aNeedList.end(); need++ ) {
			if	( ! ::stricmp( (*need).name, myname ) ) {
				list.push_back( *loop );
				break;
			}
        }
    }
	return	list;
}

// --------------------------------------------------------------------
int	CUdelProduct::XrefCount ( const char * aRef ) const {
	return  CUdelProduct::XrefCount ( itsXrefList, aRef );
}

// --------------------------------------------------------------------
int	CUdelProduct::XrefCount ( const CUdelXref_l & aList, const char * aRef ) const {
	int	count = 0;

	for	( CUdelXref_lci ref = aList.begin(); ref != aList.end(); ref++ ) {
	    for	( CUpString_lci need = (*ref).Need().begin(); need != (*ref).Need().end(); need++ ) {
			if	( (*need) == aRef ) count++;
        }
    }

	return	count;
}

// --------------------------------------------------------------------
CUdelXref_l CUdelProduct::Xref ( const CUpString_l & aMapList ) const {
	CUdelXref_l		xreflist;

	// Start by adding those maps
    for	( CUpString_lci map = aMapList.begin(); map != aMapList.end(); map++ ) {
		for	( CUdelXref_lci ref = itsXrefList.begin(); ref != itsXrefList.end(); ref++ ) {
			if	( (*ref).Name() == (*map).Value() ) {
            	xreflist.push_back( *ref );
                xreflist.back().Select( true );
                break;
            }
        }
    }

	// Go through the list adding packages that are needed - avoid adding twice
    for	( CUdelXref_lci ref = xreflist.begin(); ref != xreflist.end(); ref++ ) {
		for	( CUpString_lci need = (*ref).Need().begin(); need!= (*ref).Need().end(); need++ ) {
            CUdelXref_lci chk;
		    for	( chk = xreflist.begin(); chk != xreflist.end(); chk++ ) {
            	if	( (*chk).Name() == (*need).Value() )	break;
            }
			if	( chk == xreflist.end() ) {
				for	( CUdelXref_lci add = itsXrefList.begin(); add != itsXrefList.end(); add++ ) {
                	if	( (*add).Name() == (*need).Value() ) {
		            	xreflist.push_back( *add );
        		        xreflist.back().Select( true );
                    	break;
                    }
				}
            }
        }
    }

    // Remove packages that are referenced outside this list
	CUdelXref_li ref = xreflist.begin();
    while	( ref != xreflist.end() ) {
		int count = CUdelProduct::XrefCount( (*ref).Name().Value() );
        if	( count > CUdelProduct::XrefCount( xreflist, (*ref).Name().Value() ) ) {
			xreflist.erase( ref );
			ref = xreflist.begin();
        }
        else {
        	ref++;
        }
    }

    // Add files that have same name - avoid adding twice
    for	( CUdelXref_li ref = xreflist.begin(); ref != xreflist.end(); ref++ ) {
		char	xname[512];
        ::fnsplit( (*ref).Name().Value(), NULL, NULL, xname, NULL );
        ::strlwr( xname );
		for	( CUpString_lci file = itsFileList.begin(); file != itsFileList.end(); file++ ) {
        	char	fname[512];
            ::fnsplit( (*file).Value(), NULL, NULL, fname, NULL );
            if	( ! ::stricmp( xname, fname ) ) {
	            CUdelXref_lci chk;
			    for	( chk = xreflist.begin(); chk != xreflist.end(); chk++ ) {
        	    	if	( (*chk).Name() == (*file).Value() )	break;
            	}
				if	( chk == xreflist.end() ) {
					CUdelXref	add;
                    add.Name( *file );
    	        	xreflist.push_back( add );
   			        xreflist.back().Select( true );

                    // Add this as child
                    CUpString_l needs = (*ref).Need();
                    needs.push_back( *file );
                    (*ref).Need( needs );
        	    }
            }
		}
	}

	return xreflist;
}

// --------------------------------------------------------------------
void	CUdelProduct::XrefSelect( CUdelXref_l & aXrefList, const char * aName, bool aFlag ) const {
	CUdelXref_li xref;
	CUdelXref_li parent;

	// First find the patient
    for	( xref = aXrefList.begin(); xref != aXrefList.end(); xref++ ) {
    	if	( (*xref).Name() == aName )	break;
    }

    // No patient ? -> go home
    if	( xref == aXrefList.end() )		return;

    // No change ? -> go home
    if	( (*xref).Select() == aFlag )	return;

	// If this is a request to leave the file alone we must leave the children also
	if	( aFlag == false ) {
	    (*xref).Select( aFlag );
		for	( CUpString_lci need = (*xref).Need().begin(); need != (*xref).Need().end(); need++ ) {
			CUdelProduct::XrefSelect( aXrefList, (*need).Value(), aFlag );
	    }
		return;
    }

    // If this is a request to delete something we must check out parents first
    for	( parent = aXrefList.begin(); parent != aXrefList.end(); parent++ ) {
    	if	( (*parent).Name() == aName )	continue;
		for	( CUpString_lci need = (*parent).Need().begin(); need != (*parent).Need().end(); need++ ) {
			if	( (*need) == aName ) {
				if	( (*parent).Select() == false )	return;
            }
	    }
	}

    // Change recursively me and any referenced packages
    (*xref).Select( aFlag );
	for	( CUpString_lci need = (*xref).Need().begin(); need != (*xref).Need().end(); need++ ) {
		CUdelProduct::XrefSelect( aXrefList, (*need).Value(), aFlag );
    }
}

// --------------------------------------------------------------------
// EOF:	CUdelProduct.cpp
// --------------------------------------------------------------------
