//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "CSetupForm.h"
#include "CUpString.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"


TSetupForm *SetupForm = NULL;

//---------------------------------------------------------------------------
__fastcall TSetupForm::TSetupForm(TComponent* Owner) : TForm(Owner) {
   	struct		stat	mystat;
   	char		drive	[16];
    char		path	[256];
   	char		fname	[256];

	// Load in the init file (executable name + upp extension)
	::fnsplit( Application->ExeName.c_str(), drive, path, fname, NULL );
    ::fnmerge( itsConfig, drive, path, fname, ".ini" );
	if	( ::stat( itsConfig, &mystat ) == 0 ) {
		itsIni.Read( itsConfig );
    }
	cantEdit = 1;
	CWinIniItem_l	list;
	CWinIniItem_lci	loop;
    list = itsIni.ItemList( "Products", "Name" );
    ProductsListBox->Items->Clear();
	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		ProductsListBox->Items->Add( (*loop).Value() );
	}
    ProductsListBox->ItemIndex = -1;
	cantEdit = 0;
	TSetupForm::Populate();
}

//---------------------------------------------------------------------------
void __fastcall TSetupForm::SetControlEnable( TEdit * aEdit, bool aEnable ) {
	cantEdit++;
	aEdit->Enabled	= aEnable;
    aEdit->Color	= aEnable ? clWindow : clBtnFace;
    if	( ! aEnable ) aEdit->Text = "";
	cantEdit--;
}

//---------------------------------------------------------------------------
void __fastcall TSetupForm::ReadEditValue( TEdit * aEdit, const char * aSect, const char * aItem ) {
	CUpString	mystring;
	mystring.Read( itsIni, aSect, aItem );
    aEdit->Text = mystring.Value();
}

//---------------------------------------------------------------------------
CWinIniSection * __fastcall TSetupForm::GetCurrentSection( void ) {
    return	(CWinIniSection *)itsIni.SectionPtr( ProductsListBox->Items->Strings[ProductsListBox->ItemIndex].c_str() );
}

//---------------------------------------------------------------------------
void __fastcall TSetupForm::Populate( void ) {
	cantEdit++;
	bool	selected = ( ProductsListBox->ItemIndex >= 0 );
    DelButton->Enabled		= selected;
    AddButton->Enabled		= (itsIni.SectionPtr( "NewProduct" ) == NULL);
    TSetupForm::SetControlEnable( NameEdit, selected );
    TSetupForm::SetControlEnable( DNameEdit, selected );
    TSetupForm::SetControlEnable( RegistryEdit, selected );
    TSetupForm::SetControlEnable( GameRootEdit, selected );
    TSetupForm::SetControlEnable( MapSuffixEdit, selected );
	if	( selected ) {
		NameEdit->Text = ProductsListBox->Items->Strings[ProductsListBox->ItemIndex].c_str();
		TSetupForm::ReadEditValue( DNameEdit, 		NameEdit->Text.c_str(), "Name" );
		TSetupForm::ReadEditValue( MapSuffixEdit,	NameEdit->Text.c_str(), "MapSuffix" );
		TSetupForm::ReadEditValue( RegistryEdit, 	NameEdit->Text.c_str(), "Registry" );
		if	( RegistryEdit->Text != "" ) {
        	TSetupForm::SetControlEnable( GameRootEdit, false );
		}
        else {
			TSetupForm::ReadEditValue( GameRootEdit, NameEdit->Text.c_str(), "Gameroot" );
            if	( GameRootEdit->Text != "" ) {
	        	TSetupForm::SetControlEnable( RegistryEdit, false );
            }
		}
    }
	cantEdit--;
}

//---------------------------------------------------------------------------
void __fastcall TSetupForm::ProductsListBoxClick(TObject *Sender) {
    if	( cantEdit == 0 )	TSetupForm::Populate();
}

//---------------------------------------------------------------------------
void __fastcall TSetupForm::NameEditChange(TObject *Sender) {
	// Editing the name
    if	( cantEdit )						return;
    if	( ProductsListBox->ItemIndex < 0 )	return;
    if	( itsIni.SectionPtr( NameEdit->Text.c_str() ) )	return;
    cantEdit++;
	CWinIniSection	 oldprod = itsIni.Section( "Products" );
    CWinIniSection	 newprod;
    CWinIniSection * currsec = TSetupForm::GetCurrentSection();

	itsIni.Delete( oldprod );
	for	( CWinIniItem_lci 	item =  oldprod.ItemList().begin();
                            item != oldprod.ItemList().end();
                            item++ ) {
		if	( ::strcmp( (*item).Value(), currsec->Name() ) ) {
        	newprod.Insert( *item );
        }
        else {
        	CWinIniItem	newitem;
            newitem.Name( "Name" );
            newitem.Value( NameEdit->Text.c_str() );
            newprod.Insert( newitem );
        }
    }
    newprod.Name( "Products" );
    itsIni.Insert( newprod );
	currsec->Name( NameEdit->Text.c_str() );
	ProductsListBox->Items->Strings[ProductsListBox->ItemIndex] = NameEdit->Text.c_str();
	TSetupForm::Populate();
    cantEdit--;
}

//---------------------------------------------------------------------------
void __fastcall TSetupForm::DNameEditChange(TObject *Sender) {
	// Editing display name
    if	( cantEdit )						return;
    if	( ProductsListBox->ItemIndex < 0 )	return;
    cantEdit++;
    CWinIniSection * currsec = TSetupForm::GetCurrentSection();
	CWinIniItem		 curritm;

    try {
		curritm = *(currsec->ItemList( "Name" ).begin());
		currsec->Delete( curritm );
    }
    catch ( ... ) {
    	curritm.Name( "Name" );
    }

	curritm.Value( DNameEdit->Text.c_str() );
    currsec->Insert( curritm );
	TSetupForm::Populate();
    cantEdit--;
}

//---------------------------------------------------------------------------
void __fastcall TSetupForm::RegistryEditChange(TObject *Sender) {
	// Editing registry entry name
    if	( cantEdit )						return;
    if	( ProductsListBox->ItemIndex < 0 )	return;
    cantEdit++;
    CWinIniSection * currsec = TSetupForm::GetCurrentSection();
	CWinIniItem		 curritm;

    try {
		curritm = *(currsec->ItemList( "Registry" ).begin());
		currsec->Delete( curritm );
    }
    catch ( ... ) {
    	curritm.Name( "Registry" );
    }

	curritm.Value( RegistryEdit->Text.c_str() );
    currsec->Insert( curritm );
	TSetupForm::Populate();
    cantEdit--;
}

//---------------------------------------------------------------------------
void __fastcall TSetupForm::GameRootEditChange(TObject *Sender) {
	// Editing game root
    if	( cantEdit )						return;
    if	( ProductsListBox->ItemIndex < 0 )	return;
    cantEdit++;
    CWinIniSection * currsec = TSetupForm::GetCurrentSection();
	CWinIniItem		 curritm;

    try {
		curritm = *(currsec->ItemList( "Gameroot" ).begin());
		currsec->Delete( curritm );
    }
    catch ( ... ) {
    	curritm.Name( "Gameroot" );
    }

	curritm.Value( GameRootEdit->Text.c_str() );
    currsec->Insert( curritm );
	TSetupForm::Populate();
    cantEdit--;
}

//---------------------------------------------------------------------------
void __fastcall TSetupForm::MapSuffixEditChange(TObject *Sender) {
	// Editing map suffix
    if	( cantEdit )						return;
    if	( ProductsListBox->ItemIndex < 0 )	return;
    cantEdit++;
    CWinIniSection * currsec = TSetupForm::GetCurrentSection();
	CWinIniItem		 curritm;

    try {
		curritm = *(currsec->ItemList( "MapSuffix" ).begin());
		currsec->Delete( curritm );
    }
    catch ( ... ) {
    	curritm.Name( "MapSuffix" );
    }

	curritm.Value( MapSuffixEdit->Text.c_str() );
    currsec->Insert( curritm );
    cantEdit--;
}

//---------------------------------------------------------------------------
void __fastcall TSetupForm::AddButtonClick(TObject *Sender) {
	// Add new product
    CWinIniSection	newsection;

	newsection.Name( "NewProduct" );
    newsection.Insert( "Name",		"New Product entry" );
    newsection.Insert( "MapSuffix", ".unr" );
    newsection.Insert( "Registry",	"" );
    newsection.Insert( "Gameroot",	"" );
	itsIni.Insert( newsection );
	itsIni.Insert( "Products", "Name", "NewProduct" );
	ProductsListBox->Items->Add( "NewProduct" );
	TSetupForm::Populate();
}

//---------------------------------------------------------------------------
void __fastcall TSetupForm::DelButtonClick(TObject *Sender) {
	// Remove current product
    if	( ProductsListBox->ItemIndex < 0 )	return;
	CWinIniSection	 oldprod = itsIni.Section( "Products" );
    CWinIniSection	 newprod;
    CWinIniSection	currsec = *TSetupForm::GetCurrentSection();

	itsIni.Delete( oldprod );
	itsIni.Delete( currsec );
	for	( CWinIniItem_lci 	item =  oldprod.ItemList().begin();
                            item != oldprod.ItemList().end();
                            item++ ) {
		if	( ::strcmp( (*item).Value(), currsec.Name() ) ) {
        	newprod.Insert( *item );
        }
    }
    newprod.Name( "Products" );
    itsIni.Insert( newprod );
    ProductsListBox->Items->Delete( ProductsListBox->ItemIndex );
    ProductsListBox->ItemIndex = -1;
	TSetupForm::Populate();
}

//---------------------------------------------------------------------------
void __fastcall TSetupForm::OkButtonClick(TObject *Sender) {
	// Accept changes and close
	itsIni.Write( itsConfig );
	ModalResult = mrOk;
}

//---------------------------------------------------------------------------
void __fastcall TSetupForm::CancelButtonClick(TObject *Sender) {
	ModalResult = mrCancel;
}

//---------------------------------------------------------------------------

