//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "UnrDeleteForm.h"
#include "VerifyForm.h"
#include "CSetupForm.h"
#include "CError.hxx"
#include "TProgressDialog.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;

//---------------------------------------------------------------------------
// local:	Thread for package searcher
//---------------------------------------------------------------------------
static int	__fastcall	MyPackageLoader( void * aDoc ) {
	CUdelDoc *	myDoc = (CUdelDoc *)aDoc;

    try {
		myDoc->Initialize( Application->ExeName.c_str() );
    }

    catch ( ... ) {
    }
    return	0;
}

//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner) : TForm(Owner) {
	try {
        TMainForm::InitDoc();

	    // Initialize items in the product popup
		cantUpdate = 1;
    	MapDirectoryPopUp->Items->Clear();
	    for	( CUdelProduct_lci loop =  itsDoc.Products().begin();
    						   loop != itsDoc.Products().end();
        	                   loop++ ) {
			// Check out that we have most common denies present
            if	( ( ! (*loop).IsDeny( "core" ) ) ||
                  ( ! (*loop).IsDeny( "editor" ) ) ||
                  ( ! (*loop).IsDeny( "ipdrv" ) ) ||
                  ( ! (*loop).IsDeny( "uweb" ) ) ||
                  ( ! (*loop).IsDeny( "setup" ) ) ) {
                char	message[1024];
                ::sprintf( message, "Installation %s may have the Manifest.ini corrupt", (*loop).Name().Value() );
				Application->MessageBox( message, "Warning", MB_OK );
            }
			MapDirectoryPopUp->Items->Add( (*loop).Name().Value() );
    	}

        // Select the first one in the popup list - will initialize the list
        MapDirectoryPopUp->ItemIndex = 0;
        cantUpdate = 0;
        TMainForm::MapDirectoryPopUpChange( NULL );
        this->Show();
    }

	catch ( CError e ) {
    	Application->MessageBox( (char *)e.Error(), "Terminating", MB_OK );
		Application->Terminate();
    }

    catch ( ... ) {
    	Application->MessageBox( "Unexpected error", "Terminating", MB_OK );
		Application->Terminate();
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainForm::InitDoc( void ) {
	unsigned int	thread_id = 0;
	if	( ::BeginThread( NULL, 32768, MyPackageLoader, (void *)&itsDoc, 0, thread_id ) > 0 ) {
		// Then create the dialog
		SLEEP(100);
        if	( itsDoc.Message() ) {
		   	Application->CreateForm( __classid(TProgressDialog), &ProgressDialog );
			ProgressDialog->itsDoc = &itsDoc;
			ProgressDialog->ShowModal();
	        Application->OnIdle = NULL;
		    ProgressDialog->Release();
			ProgressDialog = NULL;
        }
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainForm::MapDirectoryPopUpChange(TObject *Sender) {
	if	( cantUpdate )	return;
    cantUpdate++;

    // Clear the list for beginning
	CustomMapList->Items->Clear();

    // Find the product
    for	( CUdelProduct_lci loop =  itsDoc.Products().begin();
   						   loop != itsDoc.Products().end();
       	                   loop++ ) {
    	if	( (*loop).Name() == MapDirectoryPopUp->Items->Strings[ MapDirectoryPopUp->ItemIndex ].c_str() ) {
			// Add all map files in this product into the list
			for	( CUpString_lci map =  (*loop).MapList().begin();
            					map != (*loop).MapList().end();
                                map++ ) {
				CustomMapList->Items->Add( (*map).Value() );
            }
			break;
        }
   	}
	DeleteButton->Enabled = false;
    cantUpdate--;
}

//---------------------------------------------------------------------------
void __fastcall TMainForm::ExitButtonClick(TObject *Sender) {
	Application->Terminate();
}

//---------------------------------------------------------------------------
void __fastcall TMainForm::CustomMapListClickCheck(TObject *Sender) {
	bool enabled = false;

	if	( cantUpdate )	return;
    cantUpdate++;

	for	( int i = 0; i < CustomMapList->Items->Count; i++ ) {
		if	( CustomMapList->Checked[i] ) {
        	enabled = true;
            break;
        }
    }
	DeleteButton->Enabled = enabled;
    cantUpdate--;
}

//---------------------------------------------------------------------------
void __fastcall TMainForm::CustomMapListDblClick(TObject *Sender) {
	if	( CustomMapList->ItemIndex >= 0 ) {
		CustomMapList->Checked[ CustomMapList->ItemIndex ] = ! CustomMapList->Checked[ CustomMapList->ItemIndex ];
        TMainForm::CustomMapListClickCheck( Sender );
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainForm::DeleteButtonClick(TObject *Sender) {
	bool	didremove = false;

    // Find the product
    for	( CUdelProduct_lci prod =  itsDoc.Products().begin();
   						   prod != itsDoc.Products().end();
       	                   prod++ ) {
    	if	( (*prod).Name() == MapDirectoryPopUp->Items->Strings[ MapDirectoryPopUp->ItemIndex ].c_str() ) {
		   	Application->CreateForm( __classid(TCVerifyForm), &CVerifyForm );

            // Create list of maps to be deleted
			CUpString_l	maplist;
			CUpString	mystring;
            CUdelXref_l	myxref;

            // Add files to the list and create the xref list
            for	( int i = 0; i < CustomMapList->Items->Count; i++ ) {
            	if	( CustomMapList->Checked[i] ) {
	            	mystring.Value( CustomMapList->Items->Strings[i].c_str() );
    	            maplist.push_back( mystring );
                }
            }
			myxref = (*prod).Xref( maplist );
            CVerifyForm->itsXref 	= &myxref;
            CVerifyForm->itsProduct	= &(*prod);

            CVerifyForm->FilesCheckListBox->Items->Clear();
            for	( CUdelXref_li xref = myxref.begin(); xref != myxref.end(); xref++ ) {
	            CVerifyForm->FilesCheckListBox->Items->Add( (*xref).Name().Value() );
            }
            for	( int i = 0; i < CVerifyForm->FilesCheckListBox->Items->Count; i++ ) {
                CVerifyForm->FilesCheckListBox->Checked[i] = true;
            }

			didremove = (CVerifyForm->ShowModal() != mrCancel);
		    CVerifyForm->Release();
			CVerifyForm = NULL;
			break;
        }
   	}

	// Initialize the document after the possible deletion
    if	( didremove ) {
        TMainForm::InitDoc();
    	TMainForm::MapDirectoryPopUpChange( Sender );
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainForm::SetupButtonClick(TObject *Sender) {
	// Open up the setup window and do some setting up !
   	Application->CreateForm( __classid(TSetupForm), &SetupForm );
	if	(SetupForm->ShowModal() != mrCancel) {
		// Reload the init file (might have beeb changed)
        TMainForm::InitDoc();

	    // Initialize items in the product popup
		cantUpdate = 1;
    	MapDirectoryPopUp->Items->Clear();
	    for	( CUdelProduct_lci loop =  itsDoc.Products().begin();
    						   loop != itsDoc.Products().end();
        	                   loop++ ) {
			// Check out that we have most common denies present
            if	( ( ! (*loop).IsDeny( "core" ) ) ||
                  ( ! (*loop).IsDeny( "editor" ) ) ||
                  ( ! (*loop).IsDeny( "ipdrv" ) ) ||
                  ( ! (*loop).IsDeny( "uweb" ) ) ||
                  ( ! (*loop).IsDeny( "setup" ) ) ) {
                char	message[1024];
                ::sprintf( message, "Installation %s may have the Manifest.ini corrupt", (*loop).Name().Value() );
				Application->MessageBox( message, "Warning", MB_OK );
            }
			MapDirectoryPopUp->Items->Add( (*loop).Name().Value() );
    	}

        // Select the first one in the popup list - will initialize the list
        MapDirectoryPopUp->ItemIndex = 0;
        cantUpdate = 0;
        TMainForm::MapDirectoryPopUpChange( Sender );
        this->Show();
    }
    SetupForm->Release();
	SetupForm = NULL;
}

//---------------------------------------------------------------------------

