//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "VerifyForm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TCVerifyForm *CVerifyForm = NULL;

//---------------------------------------------------------------------------
__fastcall TCVerifyForm::TCVerifyForm(TComponent* Owner) : TForm(Owner) {
	DeleteButton->Enabled = true;
    itsXref		= NULL;
    itsProduct	= NULL;
    cantUpdate = 0;
}

//---------------------------------------------------------------------------
void __fastcall TCVerifyForm::CancelButtonClick(TObject *Sender) {
	ModalResult = mrCancel;
}

//---------------------------------------------------------------------------
void __fastcall TCVerifyForm::FilesCheckListBoxClickCheck(TObject *Sender) {
	// Set select states according to business logic
	if	( ( FilesCheckListBox->ItemIndex >= 0 ) && ( cantUpdate == 0 ) ) {
    	cantUpdate++;
    	itsProduct->XrefSelect(	*itsXref,
        						FilesCheckListBox->Items->Strings[FilesCheckListBox->ItemIndex].c_str(),
                                FilesCheckListBox->Checked[ FilesCheckListBox->ItemIndex ] );

		int	ix = 0;
        for	( CUdelXref_li xref = itsXref->begin(); xref != itsXref->end(); xref++, ix++ ) {
			FilesCheckListBox->Checked[ix] = (*xref).Select();
		}

		bool enabled = false;
		for	( int i = 0; i < FilesCheckListBox->Items->Count; i++ ) {
    		if	( FilesCheckListBox->Checked[i] ) {
        		enabled = true;
		        break;
    	    }
	    }
    	DeleteButton->Enabled = enabled;
    	cantUpdate--;
    }
}

//---------------------------------------------------------------------------
void __fastcall TCVerifyForm::FilesCheckListBoxDblClick(TObject *Sender) {
	if	( ( FilesCheckListBox->ItemIndex >= 0 ) && ( cantUpdate == 0 ) ) {
    	cantUpdate++;
	    FilesCheckListBox->Checked[ FilesCheckListBox->ItemIndex ] = ! FilesCheckListBox->Checked[ FilesCheckListBox->ItemIndex ];
       	TCVerifyForm::FilesCheckListBoxClickCheck( Sender );
		cantUpdate--;
    }
}

//---------------------------------------------------------------------------
void __fastcall TCVerifyForm::DeleteButtonClick(TObject *Sender) {
   	char		logfile	[512];
   	char		drive	[16];
    char		path	[256];
   	char		fname	[256];
    struct stat	mystat;
    FILE *		strm;
    time_t		timenow = ::time( NULL );

	// Set up log file name for deletion
	::fnsplit( Application->ExeName.c_str(), drive, path, fname, NULL );
    ::fnmerge( logfile, drive, path, fname, ".log" );
	if	( ::stat( logfile, &mystat ) == 0 ) {
		strm = ::fopen( logfile, "a" );
    }
    else {
		strm = ::fopen( logfile, "w" );
    }

    ::strcpy( fname, ::ctime( &timenow ) );
    fname[24] = 0;
	for	( int i = 0; i < FilesCheckListBox->Items->Count; i++ ) {
    	if	( FilesCheckListBox->Checked[i] ) {
        	::unlink( FilesCheckListBox->Items->Strings[i].c_str() );
            if	( strm ) {
	            ::fprintf( strm, "%s Deleted %s\n", fname, FilesCheckListBox->Items->Strings[i].c_str() );
            }
        }
    }
    if	( strm )	::fclose( strm );
	ModalResult = mrOk;
}
//---------------------------------------------------------------------------
