// --------------------------------------------------------------------
// CUnAssaultInfo.hxx
// Whatis:  Assault info
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CUnAssaultInfo_hxx
#define CUnAssaultInfo_hxx
#include    "CUnTexture.hxx"
#include    "CUnProperty.hxx"
#include    "CUnImportTable.hxx"

// --------------------------------------------------------------------
// Declaration of the CUnAssaultInfo class
// --------------------------------------------------------------------
class   CUnAssaultInfo {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CUnAssaultInfo (  CUnFile_t &,
                    const CUnNameTable_t &,
                    const CUnExportTable_t &,
                    const CUnImportTable_t & );

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CUnAssaultInfo              ( const CUnAssaultInfo & );
    CUnAssaultInfo & operator = ( const CUnAssaultInfo & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CUnAssaultInfo();

    // ----------------------------------------------------------------
    public:     // Accessing instance data
    // ----------------------------------------------------------------
    dword_t             Count   ( void )       const;
    const char *        Desc    ( dword_t aI ) const;
    const CUnTexture_tp Shot    ( dword_t aI ) const;

    // ----------------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------------
    void        Cleanup         ( void );
    void        Free            ( void );
    void        SetFileReader   ( CUnFile_t &,
                                  const CUnNameTable_t &,
                                  const CUnExportTable_t &,
                                  const CUnImportTable_t & );
    void        SetMyShot       ( CUnProperty_t &,
                                  CUnFile_t &,
                                  const CUnNameTable_t &,
                                  const CUnExportTable_t &,
                                  const CUnImportTable_t &,
                                  int );
    void        SetMyDesc       ( CUnProperty_t &, int );
    void        SetMyCount      ( CUnProperty_t & );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    dword_t         itsCount;
    char *          itsDesc[256];
    CUnTexture_tp   itsShot[256];
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CUnAssaultInfo               CUnAssaultInfo_t;
typedef class CUnAssaultInfo *             CUnAssaultInfo_tp;

#endif  // #ifdef  CUnAssaultInfo_hxx
// --------------------------------------------------------------------
// EOF: CUnAssaultInfo.hxx
// --------------------------------------------------------------------
