// --------------------------------------------------------------------
// CUnExport.hxx
// Whatis:  Unreal Export
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CUnExport_hxx
#define CUnExport_hxx
#include    "CUnObjectFlags.hxx"

// --------------------------------------------------------------------
// Declaration of the CUnExport class
// --------------------------------------------------------------------
class   CUnExport {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CUnExport ( CUnFile & );
    CUnExport ();

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CUnExport();

    // ----------------------------------------------------------------
    public:     // Accessing instance data
    // ----------------------------------------------------------------
    dword_t             Class           ( void ) const;
    dword_t             Super           ( void ) const;
    dword_t             Package         ( void ) const;
    dword_t             ObjectName      ( void ) const;
    CUnObjectFlags_t    Flags           ( void ) const;
    dword_t             SerialSize      ( void ) const;
    dword_t             SerialOffset    ( void ) const;

    // ----------------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------------
    void        Cleanup( void );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    dword_t             itsClass;
    dword_t             itsSuper;
    dword_t             itsPackage;
    dword_t             itsObjectName;
    CUnObjectFlags_t    itsFlags;
    dword_t             itsSerialSize;
    dword_t             itsSerialOffset;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CUnExport               CUnExport_t;
typedef class CUnExport *             CUnExport_tp;
typedef list <class CUnExport>        CUnExport_tl;
typedef CUnExport_tl::iterator        CUnExport_tli;
typedef CUnExport_tl::const_iterator  CUnExport_tlci;

#endif  // #ifdef  CUnExport_hxx
// --------------------------------------------------------------------
// EOF: CUnExport.hxx
// --------------------------------------------------------------------
