// --------------------------------------------------------------------
// CUnExportTable.hxx
// Whatis:  Unreal Export table
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CUnExportTable_hxx
#define CUnExportTable_hxx
#include    "CUnExport.hxx"

// --------------------------------------------------------------------
// Declaration of the CUnExportTable class
// --------------------------------------------------------------------
class   CUnExportTable {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CUnExportTable ( CUnFile & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CUnExportTable();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operators are lethal
                // and therefore made private (won't compile if used)
    // ----------------------------------------------------------------
    CUnExportTable              ( const CUnExportTable & );
    CUnExportTable & operator = ( const CUnExportTable & );

    // ----------------------------------------------------------------
    public:     // Accessing instance data
    // ----------------------------------------------------------------
    CUnExport_t Export  ( dword_t ) const;
    dword_t     Count   ( void )	const;

    // ----------------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------------
    void        Cleanup( void );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    CUnExport_tp    itsExportList;
    dword_t         itsExportCount;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CUnExportTable               CUnExportTable_t;
typedef class CUnExportTable *             CUnExportTable_tp;

#endif  // #ifdef  CUnExportTable_hxx
// --------------------------------------------------------------------
// EOF: CUnExportTable.hxx
// --------------------------------------------------------------------
