// --------------------------------------------------------------------
// CUnImportTable.hxx
// Whatis:  Unreal Import table
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CUnImportTable_hxx
#define CUnImportTable_hxx
#include    "CUnImport.hxx"

// --------------------------------------------------------------------
// Declaration of the CUnImportTable class
// --------------------------------------------------------------------
class   CUnImportTable {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CUnImportTable ( CUnFile & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CUnImportTable();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operators are lethal
                // and therefore made private (won't compile if used)
    // ----------------------------------------------------------------
    CUnImportTable              ( const CUnImportTable & );
    CUnImportTable & operator = ( const CUnImportTable & );

    // ----------------------------------------------------------------
    public:     // Accessing instance data
    // ----------------------------------------------------------------
    CUnImport_t Import  ( dword_t ) const;
    dword_t     Count   ( void )	const;

    // ----------------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------------
    void        Cleanup( void );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    CUnImport_tp    itsImportList;
    dword_t         itsImportCount;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CUnImportTable               CUnImportTable_t;
typedef class CUnImportTable *             CUnImportTable_tp;

#endif  // #ifdef  CUnImportTable_hxx
// --------------------------------------------------------------------
// EOF: CUnImportTable.hxx
// --------------------------------------------------------------------
