// --------------------------------------------------------------------
// CUnMasterServer.hxx
// Whatis:	Unreal server info browser
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	21-APR-2003		Created	this source
// --------------------------------------------------------------------
#ifndef	CUnMasterServer_hxx
#define	CUnMasterServer_hxx
#include    "CUnServerInfo.hxx"
#include    "CTcpSocket.hxx"

// --------------------------------------------------------------------
// Declaration of the CUnMasterServerItem needed by CUnMasterServer
// --------------------------------------------------------------------
class	CUnMasterServerItem {

	// ----------------------------------------------------------------
	public:		// Constructor
	// ----------------------------------------------------------------
	CUnMasterServerItem	(	const char *	aIpAddress,
							word_t			aQueryPort,
							unreal_server_t	aServerType );


	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CUnMasterServerItem();

	// ----------------------------------------------------------------
	public:		// Copy	constructor	and	assignment operators are needed
	// ----------------------------------------------------------------
	CUnMasterServerItem				 ( const CUnMasterServerItem & );
	CUnMasterServerItem	& operator = ( const CUnMasterServerItem & );


	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *	IpAddress			( void ) const;
	word_t			QueryPort			( void ) const;
	unreal_server_t	ServerType			( void ) const;

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	char *			itsIpAddress;
	word_t			itsQueryPort;
	unreal_server_t	itsServerType;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CUnMasterServerItem				CUnMasterServerItem_t;
typedef class CUnMasterServerItem *				CUnMasterServerItem_tp;
typedef list <class CUnMasterServerItem>		CUnMasterServerItem_tl;
typedef CUnMasterServerItem_tl::iterator		CUnMasterServerItem_tli;
typedef CUnMasterServerItem_tl::const_iterator	CUnMasterServerItem_tlci;

// --------------------------------------------------------------------
// Declaration of the CUnMasterServer class
// --------------------------------------------------------------------
class	CUnMasterServer	{

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CUnMasterServer	(	const char *	aIpAddress,
						word_t			aQueryPort,
						unreal_server_t	aServerType );

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CUnMasterServer();

	// ----------------------------------------------------------------
	public:		// Copy	constructor	and	assignment operators are needed
	// ----------------------------------------------------------------
	CUnMasterServer				 ( const CUnMasterServer & );
	CUnMasterServer	& operator = ( const CUnMasterServer & );

	// ----------------------------------------------------------------
	public:		// Accessing the instance data
	// ----------------------------------------------------------------
	const CUnMasterServerItem_tl &	ServerList	( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			WaitForServer	( CTcpSocket &, unreal_server_t );
	void			SendQuery		( CTcpSocket &, unreal_server_t );
	void			ParseInput		( CTcpSocket &, unreal_server_t );
	void			ParseHtml		( CTcpSocket &, unreal_server_t );
	void			ReadSockLine	( char *, size_t, CTcpSocket & );
	const char *	ServerBanner	( unreal_server_t ) const;
	const char *	ServerQuery		( unreal_server_t ) const;

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	CUnMasterServerItem_tl	itsServerList;
};

#endif	// #ifdef  CUnMasterServer_hxx
// --------------------------------------------------------------------
// EOF:	CUnMasterServer.hxx
// --------------------------------------------------------------------
